/* -*- ObjC -*- */
#ifndef __included_boss1_h
#define __included_boss1_h

#include "unit.h"
#include "weapon.h"

enum {
    BOSS1_SMALL_LEFT_WING = 0, 
    BOSS1_SMALL_RIGHT_WING
};

#define BOSS1_MAX_SATELLITES	6

@protocol Boss1Child
- (void) setParent:(Unit<OwnsChildren> *)unit;
@end

@interface Boss1: Unit <Boss, OwnsChildren>
{
    Unit<Boss1Child> *wings[2];
    Unit<Boss1Child> *child[BOSS1_MAX_SATELLITES];

    double path_x_displacement;
    int path_progress;
    int bonus_damage;

    int satellite_tics, next_satellite;

    int fire_tics, nth_shot;
    double fang_y;

    int kamikaze_phase;
    double vv, ta, tb, tc, skid_angle;

    Weapon *outer_gun[2];
}
@end

#endif
