/* -*- ObjC -*- */
#ifndef __included_basic_tank_h
#define __included_basic_tank_h

#include "seborrhea/seborrhea.h"
#include "unit.h"
#include "weapon.h"

@interface BasicTank: Unit <VariableActivationLine, VariableTravelRange>
{
    Sebum<SebImage> *turret;
    double turret_angle, desired_turret_angle;
    Unit *target;
    Weapon *gun;
    Class base_debris;
    Class turret_debris;
    double turret_rot_speed;

    /* Tracks. */
    Class tracks;
    double last_track_x, last_track_y;
    double track_separation_sq;

    double travel_range;
}
@end

@interface BasicTank (Turret)
- (void) drawTurret:(BITMAP *)dest;
- (void) drawTurret:(BITMAP *)dest Displacement:(int)x_ :(int)y_;
- (void) aimTurret;
@end

@interface BasicTank (Tracks)
- (void) layTracks;
@end

#endif
