/* -*- ObjC -*- */
#ifndef __included_all_units_h
#define __included_all_units_h

#define LOAD_UNIT_DATA_FOR(c,air)	load_unit_data_for([c class], air)

typedef struct {
    Class class;
    BOOL loads_data;
    BOOL loaded, required;
    BOOL show_in_map_editor;
} unit_table_helper_t;

typedef struct {
    unsigned int max_classes;
    unsigned int num_classes;
    unit_table_helper_t *class_data;	/* Array. */
} unit_table_t;

extern unit_table_t air_units_table, ground_units_table;

BOOL load_unit_data_for(Class class, BOOL air);
void unload_unnecessary_unit_data(void);
void mark_all_unit_data_necessary(void);
void mark_all_unit_data_unnecessary(void);

Class find_class_by_name(const char *name, BOOL air);

void make_all_units_tables(void);
void shutdown_special_units(void);

#endif
