/* -*- ObjC -*- */
#ifndef __included_unit_h
#define __included_unit_h

#include "candy/chunk.inc"
#include "thing.h"
#include "unit-protocol.inc"
#include "collision.inc"

#define SHADOW_DISPLACEMENT		25	/* Other units might want to know. */
#define FLAG_DEATH_SPAWN_POWERUP	(FLAG_DEATH_SPAWN_PRIMARY_POWERUP|   \
					 FLAG_DEATH_SPAWN_SECONDARY_POWERUP| \
					 FLAG_DEATH_SPAWN_TERTIARY_POWERUP|  \
					 FLAG_DEATH_SPAWN_HEALTH_POWERUP|    \
					 FLAG_DEATH_SPAWN_NUKE_POWERUP)

enum UNIT_FLAGS {
    FLAG_INVINCIBLE	= 0x01,
    FLAG_FIRING_ENABLED	= 0x02,
    FLAG_MOVING_ENABLED	= 0x04,
    FLAG_DYING		= 0x10,
    FLAG_DEAD		= 0x20,
    FLAG_SPAWN_CHUNKS_ON_DEATH	= 0x40,

    /* Any flags beyond this point will be saved! */
    FLAG_DEATH_SPAWN_PRIMARY_POWERUP	= 0x0100,
    FLAG_DEATH_SPAWN_SECONDARY_POWERUP	= 0x0200,
    FLAG_DEATH_SPAWN_TERTIARY_POWERUP	= 0x0400,
    FLAG_DEATH_SPAWN_HEALTH_POWERUP	= 0x0800,
    FLAG_DEATH_SPAWN_NUKE_POWERUP	= 0x1000,
    FLAG_ONLY_SPAWN_IN_TWO_PLAYER	= 0x2000
};

enum INACTIVE_UNIT_UPDATE_STATE {
    INACTIVE_UNIT_REST,
    INACTIVE_UNIT_DELETE,
    INACTIVE_UNIT_ACTIVATE
};

@class Projectile;
struct BITMAP;

@interface Unit: CollidableThing
{
    int critical_health;	/* Health before we start blinking. */

    /* Location & movement */
    int activate_y;		/* Larger means activate earlier. */
    double angle, speed;

    /* Appearance */
    Sebum<SebImage> *shadow;
    BOOL rotated_sprite;
    int flash_tics;

    /* Miscellaneous */
    unsigned int flags;
    unsigned int chunk_colours;
}
        /* Initialization. */
+ (BOOL) loadPrerequisites;
+ (BOOL) loadData:(SebFile **)sebum :(const char *)dir;
- (id) setAngle:(double)theta;
- (id) setX:(double)x_ Y:(double)y_;
- (void) delete;
- (void) spawnDyingExplosions;
- (void) die;

	/* Drawing. */
- (void) drawShadow:(BITMAP *)dest;

	/* Update. */
- (enum INACTIVE_UNIT_UPDATE_STATE) readyToActivate;
- (void) activate;
- (void) enableMovement;
- (void) move;
- (void) fire;

	/* Collisions */
- (int) flags;
- (int) collisionLists;
- (int) receiveDamage:(int)damage type:(enum DAMAGE_TYPE)type;
- (int) receiveDamage:(int)damage type:(enum DAMAGE_TYPE)type from:(int)unit_id;

	/* Load/Save. */
- (void) importUnitProperties:(char *)str;
- (char *) exportUnitProperties:(char *)str;

	/* For use in map editor only! */
- (double) angle;
@end

@interface Unit (Debris)
- (void) burstIntoChunks;
@end

@interface Unit (Powerups)
- (void) dropPowerups;
@end

/*------------------------------------------------------------*/

extern int shadow_opacity;
extern Unit<Boss> *boss;

void draw_units(BITMAP *dest, enum UNIT_LIST list);
void draw_unit_shadows(BITMAP *dest);

void update_units(void);

Unit *spawn_unit(Class class, double x, double y,
		 enum UNIT_LIST list, BOOL at_start);
void destroy_unit(Unit *unit);
void purge_units_below(double yy);

void unit_reset(void);
void unit_init(void);
void unit_shutdown(void);

#endif
