/* -*- ObjC -*- */
#ifndef __included_thing_h
#define __included_thing_h

#include <allegro.h>		/* XXX */
#include <objc/Object.h>
#include "seborrhea/seborrhea.h"

/* Thing:update return values. */
enum THING_UPDATE_STATE {
    THING_NORMAL = 0,
    THING_DEAD = 1
};

@class Thing;

@protocol DetectsCollision
- (int) collisionRoutinePriority;
- (void) getX:(double* const)x_ Y:(double* const )y_;
- (void) getW:(int* const)w_ H:(int* const)h_;
- (void) getX:(double* const)x_ Y:(double* const)y_
	    W:(int* const)w_ H:(int* const)h_;
- (BOOL) checkCollisionWith:(Thing<DetectsCollision> *)object;
- (BOOL) collidesWith:(Thing<DetectsCollision> *)object;
@end


@interface Thing: Object
{
    int health;
    double x, y;
    unsigned int w, h;		/* Collision width/height. */

    Sebum<SebImage> *sprite;
}
+ (BOOL) loadData;
+ (void) shutdown;
- (id) setX:(double)x_ Y:(double)y_;
- (BOOL) mayStillInfluenceGameplay;
- (enum THING_UPDATE_STATE) update;
- (void) draw:(BITMAP *)dest;
- (void) drawBoundingBox:(BITMAP *)dest;
@end

@interface CollidableThing: Thing <DetectsCollision>
@end

#endif
