/* -*- ObjC -*- */
#ifndef __included_sound_h
#define __included_sound_h

#include "seborrhea/seborrhea.h"

#define PANRANGE	128
#define PANMAX		255
#define SOUND_VOLMAX	255.0

enum VOICE_CHANNEL {
    WEAPON_1 = 0,
    WEAPON_2,
    WEAPON_3,
    WEAPON_4,
    TOTAL_RESERVED_CHANNELS,
    PRIMARY_WEAPON_CHANNELS
};

extern BOOL sound_initialized;
extern BOOL sound_reverse_stereo;
extern int sound_vol;

void play_panned_sample(Sebum<SebSample> *spl, int x);
BOOL play_voice(Sebum<SebSample> *spl, int x, int p, enum VOICE_CHANNEL c);
void play_voice_on_channels(Sebum<SebSample> *spl, int x, int p, enum VOICE_CHANNEL c);
void free_reserved_sounds(void);

int sound_init(void);
void sound_shutdown(void);

#endif
