/* -*- ObjC -*- */
#ifndef _seb_included_sebum_music_h__
#define _seb_included_sebum_music_h__

#include "seborrhea/sebum.h"

@protocol SebMusic
- (id<SebMusic>) setMusicFilename:(const char *)name;
- (const char *) getMusicFilename;

- (BOOL) loadFile:(void *)mem :(const long)size;
- (void) unloadFile;

/* play:
 *
 * Play the loaded music.  Return YES if we play back has started.
 *
 * 0 <= vol <= 255
 * 0 <= pan <= 255
 * speed = 1000 = normal speed
 */
- (BOOL) playWithVol:(const int)vol Loop:(const BOOL)loop;
- (BOOL) playWithVol:(const int)vol Pan:(const int)pan Speed:(const int)speed
		Loop:(const BOOL)loop;
- (void) adjustVol:(const int)vol;
- (BOOL) poll;
- (void) stop;
@end

#endif
