/* -*- ObjC -*- */
#ifndef _seb_included_sebum_image_h
#define _seb_included_sebum_image_h

@protocol SebImage
- (void) setPivotX:(int)x Y:(int)y;

	/* Dimensions. */
- (unsigned int) width;
- (unsigned int) height;

	/* Draw, with transparency. */
- (void) drawTo:(void *)dest X:(int)x Y:(int)y;
- (void) drawTo:(void *)dest X:(int)x Y:(int)y Angle:(double)theta;
- (void) drawTo:(void *)dest X:(int)x Y:(int)y Angle:(double)theta Scale:(double)scale;

	/* Draw, with transparency and translucency. */
- (void) drawTo:(void *)dest X:(int)x Y:(int)y Alpha:(int)alpha;
- (void) drawTo:(void *)dest X:(int)x Y:(int)y Alpha:(int)alpha Angle:(double)theta;

	/* Draw, with transparency and tinting. */
- (void) drawTo:(void *)dest X:(int)x Y:(int)y Tint:(int)r :(int)g :(int)b :(int)alpha;
- (void) drawTo:(void *)dest X:(int)x Y:(int)y Tint:(int)r :(int)g :(int)b :(int)alpha Angle:(double)theta;

	/* Draw, without transparency. */
- (void) drawTo:(void *)dest X:(int)x Y:(int)y W:(int)w H:(int)h;
- (void) drawFromX:(int)sx Y:(int)sy To:(void *)dest X:(int)x Y:(int)y W:(int)w H:(int)h;
@end

#endif
