/* -*- ObjC -*- */
#ifndef _seb_included_seborrhea_property_h
#define _seb_included_seborrhea_property_h

#include "seborrhea/sebum.h"
#include "seborrhea/token.h"

#define MAX_METAFILE_PROPERTY_HANDLERS	5

typedef void (*property_handler_proc_t)(Sebum *, unsigned int, Token *[]);

typedef struct {
    const char *prop;
    property_handler_proc_t proc;
} metafile_property_handler_t;

extern metafile_property_handler_t metafile_property_handlers[MAX_METAFILE_PROPERTY_HANDLERS];

void seborrhea_register_metafile_property(const char *, property_handler_proc_t);

#endif
