/* -*- ObjC -*- */
#ifndef _seb_included_seborrhea_filetype_h
#define _seb_included_seborrhea_filetype_h

#include "seborrhea/dirlist.h"
#include "seborrhea/sebum.h"
#include "seborrhea/sebum-container.h"

#define MAX_FILETYPE_HANDLERS		10

typedef BOOL (*filetype_handler_proc_t)(const char *, const char *, unsigned int, Sebum<SebContainer> *, DirectoryList *);

typedef struct {
    const char *ext;
    filetype_handler_proc_t proc;
} filename_extension_handler_t;

extern filename_extension_handler_t filename_extension_handlers[MAX_FILETYPE_HANDLERS];

void seborrhea_register_filetype_handler(const char *, filetype_handler_proc_t);

#endif
