/* -*- ObjC -*- */
#ifndef _seb_included_seborrhea_command_h
#define _seb_included_seborrhea_command_h

#include "seborrhea/sebum.h"
#include "seborrhea/sebum-container.h"
#include "seborrhea/token.h"

#define MAX_METAFILE_COMMANDS		10

typedef BOOL (*command_handler_proc_t)(const char *, unsigned int, unsigned int, Token *[], Sebum<SebContainer> *, DirectoryList *);

typedef struct {
    const char *command;
    command_handler_proc_t proc;
} metafile_command_handler_t;

extern metafile_command_handler_t metafile_command_handlers[MAX_METAFILE_COMMANDS];

void seborrhea_register_metafile_command(const char *, command_handler_proc_t);

#endif
