/* -*- ObjC -*- */
#ifndef _seb_included_seborrhea_allegro_h
#define _seb_included_seborrhea_allegro_h

#include <allegro.h>
#include "seborrhea/sebum.h"
#include "seborrhea/sebum-image.h"
#include "seborrhea/sebum-sample.h"

@interface SebImageAllegro: Sebum <SebImage>
{
    BITMAP *bitmap;
    int pivot_x, pivot_y;
}
- (BOOL) grabFromBitmap:(BITMAP *)source WithX:(unsigned int)sx Y:(unsigned int)sy W:(unsigned int)w H:(unsigned int)h;
- (BOOL) setBitmap:(BITMAP *)bmp;
- (BITMAP *) bitmap;		/* XXX */
@end

@interface SebImageAllegroAlpha: SebImageAllegro
@end

@interface SebSampleAllegro: Sebum <SebSample>
{
    SAMPLE *sample;
    unsigned int default_volume;
}
- (SAMPLE *) sample;		/* XXX */
@end

BOOL seborrhea_allegro_init(void);
void seborrhea_allegro_shutdown(void);

#endif
