/* -*- ObjC -*- */
#ifndef _seb_included_container_animation_h
#define _seb_included_container_animation_h

#include "seborrhea/container.h"
#include "seborrhea/sebum-image.h"
#include "seborrhea/sebum-unique.h"


enum SEB_ANIMATION_LOOP_METHOD {
    LOOP_NONE = 0,
    LOOP_FORWARD,
    LOOP_PING_PONG
};


@interface SebAnimation: AbstractSebContainer <SebImage>
{
    unsigned int w, h;
    unsigned int delay;
    enum SEB_ANIMATION_LOOP_METHOD loop_method;
}
- setFrameDelay:(unsigned int)t LoopMethod:(enum SEB_ANIMATION_LOOP_METHOD)loop_method;
- (unsigned int) frameDelay;
- (enum SEB_ANIMATION_LOOP_METHOD) loopMethod;

- (unsigned int) numFrames;
- (Sebum<SebImage> *) getFrame:(int)nth;
- (unsigned int) nextFrame:(unsigned int)curr;
@end


@interface SebAnimatorManual: Sebum <SebImage, UniqueSebum>
{
    SebAnimation *anim;
    int frame;
    enum SEB_ANIMATION_LOOP_METHOD loop_method;
}
- (SebAnimation *)getAnimation;
- resetAnimation;
- setAnimation:(SebAnimation *)anime;
- setFrame:(int)frame_;
- setLoopMethod:(enum SEB_ANIMATION_LOOP_METHOD)method;

- (int) currentFrameNumber;
- (Sebum<SebImage> *) currentFrame;
- (BOOL) nextFrame;
- (void) updateFrame;

- (BOOL) animationEnded;
@end


@interface SebAnimatorManualWithDelay: SebAnimatorManual
{
    int frame_tics;
}
@end


@interface SebAnimator: SebAnimatorManualWithDelay
@end

#endif
