/* -*- ObjC -*- */
#ifndef __included_scramble_letter_h
#define __included_scramble_letter_h

typedef struct {
    const char *name;		/* Letter graphic name. */
    int x, y;			/* Where to end up. */
    double theta, dist;		/* Where we are relative to (x,y). */
} letter_t;

extern letter_t game_over_letters[];
extern letter_t high_score_letters[];
extern letter_t level_complete_letters[];

void scramble_letters(letter_t ls[]);
void unscramble_letters(letter_t ls[]);
void draw_letters(BITMAP *dest, letter_t ls[]);

#endif
