/* -*- ObjC -*- */
#ifndef __included_toothpaste_h
#define __included_toothpaste_h

#include "player-weapon.h"
#include "projectile.h"
#include "unit.h"
#include "waypoint.h"

@interface Toothpaste: AllyProjectile
{
    waypoint_t *the_path;
    int path, path_max;
    double min, max;

    int length;
    int jump_range;

    double min_travel_dist;
}
- (id) setMinAngle:(double)theta_min maxAngle:(double)theta_max_;
@end

/* Should be read-only from outside module. */
extern int toothpaste_flavour;

void toothpaste_set_flavour(int flav);
void unlockToothpaste(int pid);
void unlockToothpaste2(const Unit *unit);
void fireToothpaste(double x, double y, primary_weapon_t *w, const int pid);

#endif
