/* -*- ObjC -*- */
#ifndef __included_projectile_h
#define __included_projectile_h

#include "thing.h"
#include "projectiles/all-projs.h"
#include "unit.h"

/*--------------------------------------------------------------*/

#define derive_registerProjectile()					\
	(id) initialize							\
	{ REGISTER_PROJECTILE(self); return self; }

#define derive_loadDataProjectile(sebum,dir)				\
	(BOOL) loadData							\
	{ return [super loadData:&sebum :dir]; }

#define derive_shutdownProjectile(sebum)				\
	(void) shutdown							\
	{ FREE_SEBFILE(sebum); }

/*--------------------------------------------------------------*/

struct BITMAP;

@interface Projectile: CollidableThing
{
    /* Location & movement */
    double angle, speed;
    BOOL rotated_sprite;
    double xv, yv;		/* Optimisation stuff. */
    BOOL recalculate_velocity;

    BOOL alliance;		/* yes = player, no = enemy. */
}
        /* Initialization. */
+ (BOOL) loadData:(SebFile **)sebum :(const char *)dir;
- (id) setAlliance:(BOOL)good;
- (id) setAngle:(double)theta;
- (void) die;

	/* Collisions. */
+ (int) collisionLists;
+ (enum DAMAGE_TYPE) damageType;
- (int) receiveDamage:(int)damage;
- (int) damage;
- (int) parentID;

- (void) unlock:(const Unit *)unit;
@end

@interface AllyProjectile: Projectile
{
    unsigned int parent_id;
}
- (id) setParentID:(int)n;
@end

void draw_projectiles(BITMAP *dest);
void update_projectiles(void);
void projectiles_unlock_unit(const Unit *unit);

Projectile *spawn_projectile(Class class, double x, double y, BOOL is_goodie);

void projectile_init(void);
void projectile_shutdown(void);

#endif
