/* -*- ObjC -*- */
#ifndef __included_powerup_h
#define __included_powerup_h

#include "player.h"
#include "seborrhea/seborrhea.h"
#include "thing.h"

struct BITMAP;

@interface Powerup: CollidableThing
{
    int path;			/* Path progress. */
    double path_x_displacement, path_y_displacement;

    int state, change_tics;
}
- (void) givePowerupTo:(Player *)pl;
@end

	/* Weapons. */
@interface PrimaryPowerup: Powerup
@end

@interface SecondaryPowerup: Powerup
@end

@interface TertiaryPowerup: Powerup
@end

	/* Miscellaneous Powerups. */
@interface HealthPowerup: Powerup
{
    Sebum<SebImage> *back;
    double theta;
}
@end

@interface NukePowerup: Powerup
{
    Sebum<SebImage> *back;
    double theta;
}
@end

void draw_powerups(BITMAP *dest);
void update_powerups(void);
Powerup *spawn_powerup(Class class, double x, double y);

void powerup_init(void);
void powerup_shutdown(void);

#endif
