/* -*- ObjC -*- */
#ifndef __included_player_h
#define __included_player_h

#include "linklist.h"
#include "player-weapon.h"
#include "unit.h"
#include "mmpk.h"

#define MAX_PLAYERS		2

enum WEAPON_GROUP {
    PRIMARY_WEAPON,
    SECONDARY_WEAPON,
    TERTIARY_WEAPON,
    NUM_WEAPONS
};

typedef enum WEAPON_GROUP weapon_group_t;

/*--------------------------------------------------------------*/

@class SebAnimation;
@class Player;

@protocol PlayerChild
- (void) exciteMeIgniteMe;
- (id) setParent:(Player *)p;
@end

@interface Player: Unit <OwnsChildren>
{
    double xv, yv;		/* This is really only for dying and determining which animation to use. */

    /* Weapons. */
    primary_weapon_t	primary_weapon;
    secondary_weapon_t	secondary_weapon;

    struct {
	enum TERTIARY_WEAPON weapon;
	List *children;			/* Robots and Satellites. */
    } tertiary_weapon;

    /* This is for 1 press = 1 shot feel. */
    int fire_tics;
    BOOL fire_was_down;

    /* Animations. */
    SebAnimation *anims[3];		/* NUM_ORIENTATIONS */
    SebAnimation *animation;		/* Current one in use. */

    int invulnerable_tics;
    int pid;
}
- (void) drawHealth:(BITMAP *)bmp;
- (void) increaseVelocity:(double)xv_ :(double)yv_;
- (void) zoom;
- (void) openFire;
- (void) haltFire;
- (BOOL) isFiring;

- (void) setPrimaryWeaponTo:(const enum PRIMARY_WEAPON)new_weapon;
- (void) setSecondaryWeaponTo:(const enum SECONDARY_WEAPON)new_weapon;
- (void) setTertiaryWeaponTo:(const enum TERTIARY_WEAPON)new_weapon;
- (enum PRIMARY_WEAPON) weaponType;

- (void) increaseScore:(int)n;
- (void) incrementKillsFrom:(double)x_ :(double)Y_;
- (int) playerID;
@end

@interface Player (Demo)
- (void) recordDemoCheckPoint:(PACKFILE *)fp;
- (void) readDemoCheckPoint:(MEMORY_FILE *)fp;
@end

@interface Player2: Player
@end

extern Player *player[MAX_PLAYERS];
extern unsigned int num_players;

extern primary_weapon_t playblast_primary_weapon;
extern secondary_weapon_t playblast_secondary_weapon;
extern enum TERTIARY_WEAPON playblast_tertiary_weapon;

#endif
