/* -*- ObjC -*- */
#ifndef __included_player_stats_h
#define __included_player_stats_h

#include "player.h"

#define NUM_KILL_RANGES_BUCKETS		10

enum TRIT {
    TRIT_UNDETERMINED = -1,
    TRIT_NO,
    TRIT_YES
};

typedef struct 
{
    unsigned int score;
    unsigned int cheated_death_count;

    unsigned int kills;
    unsigned int kill_bucket[NUM_KILL_RANGES_BUCKETS];

    unsigned int crashes, hits;

    enum TRIT is_powerup_hog;
    unsigned int powerups_gained;
} stats_t;

extern stats_t player_stats[MAX_PLAYERS];

void draw_death_statusbar(BITMAP *dest, unsigned int pid);
void clear_stats_for_player(unsigned int pid);

#endif
