/* -*- ObjC -*- */
#ifndef __included_newmenu_h
#define __included_newmenu_h

#include <objc/Object.h>
#include "seborrhea/container-file.h"

/* The greatest hero of them all! */
#define MENU_FONT_NAME		"fonts/am30"
/* #define MENU_FONT_SIZE		30 */
#define MENU_SPEED		20
#define MENU_SECONDS		MENU_SPEED
#define MENU_MUSIC_DIRNAME	"music/menu"
#define HOTKEY_MENU		-1

typedef struct {
    const char *text;
    int hotkey;

    /* slider_max determines the type of menu item this is.
     * slider_max < 0: slider without meter.
     * slider_max = 0: push button.
     * slider_max = 1: check box/toggle button.
     * slider_max > 1: slider with meter.
     *
     * Further, the menu item is a push button, thens:
     * slider_val < 0: inactive, skip.
     * slider_val = 0: active
     *
     * Yes, the menu is dirty.
     */

    int slider_val, slider_max;
    int r, g, b;
    void (*action)(void);
} menuitem_t;

typedef struct {
    int selected_item;
    int n_menuitems;
    menuitem_t menuitem[];
} menu_t;

extern BOOL emergency_exit;
extern SebFile *menu_sebum;
extern volatile int counter;

void play_back_sound(void);
void play_bing_sound(void);
void play_okay_sound(void);
BOOL menu_select_previous(void);
BOOL menu_select_next(void);
BOOL menu_select_left(void);
BOOL menu_select_right(void);
void selected_item_colour(int *r, int *g, int *b, int t);

void play(const char *level_list[], unsigned int num_levels,
	  BOOL check_highscore, BOOL prefix_with_data_dir);

void menu_common_update(void);
void do_newmenu(void);

#endif
