/* -*- ObjC -*- */
#ifndef __included_maybe_fblend_h
#define __included_maybe_fblend_h

#ifndef NO_FBLEND

#include <allegro.h>

#define blender_begin_primitives()
#define blender_end_primitives()

#define blender_set_add(alpha)			_blender_set_alpha(alpha)
#define blender_hline_add(bmp,x,y,w,c)		blender_rect_add(bmp,x,y,w,1,c)
extern void blender_rect_add(BITMAP* const bmp,
			     const int x, const int y,
			     const int w, const int h, const int c);

#define blender_set_trans(alpha)			_blender_set_alpha(alpha)
extern void blender_rect_trans(BITMAP* const bmp,
			       const int x, const int y,
			       const int w, const int h, const int c);

extern void _blender_set_alpha(const int alpha);

#else

#include <allegro.h>

extern void blender_begin_primitives(void);
extern void blender_end_primitives(void);

#define blender_set_add(alpha)			set_add_blender(0xff, 0xff, 0xff, alpha)
#define blender_hline_add(bmp,x,y,w,c)		_blender_hline(bmp,x,y,w,c)
#define blender_rect_add(bmp,x,y,w,h,c)		_blender_rectfill(bmp,x,y,w,h,c)

#define blender_set_trans(alpha)			set_trans_blender(0xff, 0xff, 0xff, alpha)
#define blender_hline_trans(bmp,x,y,w,c)	_blender_hline(bmp,x,y,w,c)
#define blender_rect_trans(bmp,x,y,w,h,c)	_blender_rectfill(bmp,x,y,w,h,c)

extern void _blender_hline(BITMAP* const bmp,
			      const int x, const int y,
			      const int w, const int c);

extern void _blender_rectfill(BITMAP* const bmp,
			      const int x, const int y,
			      const int w, const int h, const int c);

#endif



#endif
