/* -*- ObjC -*- */
#ifndef __included_maybe_alrand_h__
#define __included_maybe_alrand_h__

#ifndef NO_ALRAND

#include "alrand/alrand.h"

#else  /* NO_ALRAND */

#include <stdlib.h>

#define alrand_init()
#define alrand_exit()
#define alrand_set_global_generator_type(x)

#define alrand_rand()		random()
#define alrand_srand(seed)	srandom(seed)

#define alrand_create(a, b)		calloc(1, sizeof(struct drand48_data))
#define alrand_destroy(state)		free(state)
#define alrand_seed(state, seed)	srand48_r(seed, state)

typedef unsigned int alrand_uint32_t;
typedef struct drand48_data alrand_state;

extern alrand_uint32_t alrand_generate(alrand_state *state);

#endif /* NO_ALRAND */

#endif
