/* -*- ObjC -*- */
#ifndef __included_tile_connection_h
#define __included_tile_connection_h

#define MAX_SETS	20

typedef struct {
    const char *tile_name;
    int connect[4];		/* tl, tr, bl, br */
} connection_data_t;


typedef struct {
    const char *base_name;

    unsigned int n_items;
    connection_data_t data[16];
} connection_set_t;


extern connection_set_t connection_set[MAX_SETS];

const char *rename_tile(const char *name);
int find_in_set(const char *name, int j);
int find_tile_connection_set_by_name(const char *name);

#endif
