/* -*- ObjC -*- */
#ifndef __included_map_proc_h
#define __included_map_proc_h

#include "gui/gui-widgets.h"
#include "linklist.h"
#include "map-editor/redit.h"
#include "map.h"
#include "seborrhea/seborrhea.h"

@class Unit;

typedef struct map_proc_visuals {
    int air_units;
    int ground_units;
    int hruler;
    int vruler;
} map_proc_visuals;

@interface MapProc: Widget
{
    /* Scrollbars. */
    HScrollbar *hscrollbar;
    VScrollbar *vscrollbar;

    Map *the_map;

    /* The tile/unit to place. */
    BOOL auto_plonk;
    Sebum<SebImage> *lmb_tile, *rmb_tile;
    Class selected_ground_class;
    Class selected_air_class;
    unsigned int selected_formation;

    /* Tagged units. */
    List *tagged_list;

    /* What to show. */
    BOOL snap_to_grid;
    struct map_proc_visuals visable;

    int mouse_click_x, mouse_click_y;	/* Where the mouse was pressed. */
    int last_mouse_x, last_mouse_y;	/* Where the mouse was the last frame. */
}
- initMap;
- freeMap;
- (void) loadMap:(const char *)filename;
- (void) deleteUnit:(Unit *)unit;
- (void) setSelectedLMBItem:(int)data;
- (void) setSelectedRMBItem:(int)data;
- (Class) getSelectedUnitClass;
@end

Unit *findUnitAt(double x, double y);

#endif
