/* -*- ObjC -*- */
#ifndef __included_linklist_h
#define __included_linklist_h

#include <objc/Object.h>

//#define DEBUG_LINKLIST

#define foreach(it, l)		for ((it) = [(l) getIterator]; (it) != nil; (it) = [(it) next])
#define foreach_nx(it,nx,l)	for ((it) = [(l) getIterator]; (it) != nil; (it) = (nx))

/* Please - pretty please - use this to create lists to make debugging easier.
   Usage: my_list = [LIST_NEW]; */
#ifdef DEBUG_LINKLIST
# define LIST_NEW	[List alloc] initWithDebug: __FILE__ :__LINE__
#else
# define LIST_NEW	List new
#endif

/*------------------------------------------------------------*/

@interface ListIterator: Object
{
    struct ListItem *current_node;
}
- (id) initWithList:(struct ListItem *)list;
- (id) getItem;
- (ListIterator *) next;
@end

@interface List: Object
{
    struct ListItem *the_list;
    struct ListItem *end_item;

#ifdef DEBUG_LINKLIST
    const char *_source_file;
    int _source_line;
#endif
}
- init;
- initWithDebug:(char *)file :(int)line;
- free;

- (void) insertItem:(id)item;
- (void) insertItem:(id)item before:(id)item2;
- (void) insertItem:(id)item after:(id)item2;
- (void) insertItemAtEnd:(id)item;

- (BOOL) removeItem:(id)item;
- (void) removeAllItems;

- (ListIterator *) getIterator;
- (BOOL) isEmpty;
- (int) length;
@end

#endif
