/* -*- ObjC -*- */
#ifndef __included_input_h
#define __included_input_h

#include <allegro.h>
#include <objc/Object.h>
#include "input-joystick.h"
#include "input-keyboard.h"

#ifdef WINFF
# include "allegff/winff.h"
#endif

#ifndef MAX_PLAYERS
# define MAX_PLAYERS	2
#endif

/*--------------------------------------------------------------*/

typedef struct {
    KeyboardController *keyboard;
    JoystickController *joystick;
} player_controls_t;

extern KeyboardController *menu_keyboard_controls;
extern JoystickController *joystick_controller[MAX_JOYSTICKS];
extern player_controls_t player_controls[MAX_PLAYERS];

#ifdef WINFF
# define rumble_pad_for_player_hurt(pl)		[player_controls[pl].joystick rumbleHurt]
# define rumble_pad_for_player_dying(pl)	[player_controls[pl].joystick rumbleDying]
#endif

void do_input(void);
void poll_raid_keys(int n_players);
BOOL start_pressed(void);
BOOL start_released(void);
BOOL retry_released(void);
BOOL okay_released(void);
BOOL menu_released(void);

int input_init(void);
void input_shutdown(void);

#endif

