/* -*- ObjC -*- */
#ifndef __included_input_joystick_h
#define __included_input_joystick_h

#include <allegro.h>
#ifdef WINFF
# include <winff.h>
#endif
#include "input-controller.h"

#define MAX_JOY_NAME_LENGTH	32
#define JOYSTICK_CFG		"joystick.cfg"

@interface JoystickController: InputController
{
    char name[MAX_JOY_NAME_LENGTH];

    JOYSTICK_INFO *j;
    int joy_num;
    int x_stick, x_axis;
    int y_stick, y_axis;
    int start_b, menu_b;

    BOOL ignore_stick[MAX_JOYSTICK_STICKS];

#ifdef WINFF
    FFEFFECT *ff_player_hurt;
    FFEFFECT *ff_player_dying;
#endif
}
- initWithJoystickNumber:(int)n ConfigFile:(FILE *)fp;
- (const char *) name;
- (int) joystickNumber;
- (int) xPosition;
- (int) yPosition;

#ifdef WINFF
- (void) rumbleHurt;
- (void) rumbleDying;
#endif
@end

extern BOOL joy_enabled;

/*--------------------------------------------------------------*/

#define JOYSTICK_CFG_HEADER						\
"; This file should be named 'joystick.cfg' and placed in either the\n"	\
"; root Raid'em directory, or inside ~/.raidem/\n"			\
";\n"									\
"; 'primary-stick' refers to the stick to use while playing.\n"		\
";\n"									\
"; 'ignore-stick' refers to any stick whose data should not be read.\n"	\
"; This is useful if we detect more sticks on your joystick than it\n"	\
"; actually has, screwing up menu navigation.\n"			\
";\n"									\
"; Stick numbers should be a number between 0 and 4 (inclusive).\n\n"

#endif
