/* -*- ObjC -*- */
#ifndef __included_input_controller_h
#define __included_input_controller_h

#include <objc/Object.h>

enum RAID_KEY {
    RAID_KEY_UP,
    RAID_KEY_DOWN,
    RAID_KEY_LEFT,
    RAID_KEY_RIGHT,
    RAID_KEY_START,
    RAID_KEY_MENU,
    RAID_KEY_FIRE,
    NUM_RAID_KEYS,
    RAID_KEY_FIRE2		/* Hack. */
};

typedef enum RAID_KEY raid_key_t;

@interface InputController: Object
{
    BOOL pressed[NUM_RAID_KEYS];
    BOOL was_pressed[NUM_RAID_KEYS];
    int repeat_tics[NUM_RAID_KEYS];
    BOOL auto_repeat[NUM_RAID_KEYS];
}
- (BOOL) seekInFile:(const char *)fn :(FILE *)fp For:(const char *)seekee;
- (void) poll;
- (void) pollUpdatePressed;
- (BOOL) pressed:(raid_key_t)k;
- (BOOL) held:(raid_key_t)k;
- (BOOL) released:(raid_key_t)k;
- (void) setKey:(raid_key_t)k To:(int)k_;
- (int) getKey:(raid_key_t)k;
@end


@interface InputController (Config)
- (void) readConfigFile:(FILE *)fp :(const char *)section;
- (void) writeConfigFile:(FILE *)fp :(const char *)section;
@end

#endif
