/* -*- ObjC -*- */
#ifndef __included_hiscore_h
#define __included_hiscore_h

#define NUM_HIGH_SCORE_ITEMS	10

enum HIGH_SCORE_SOURCE {
    SOURCE_UNKNOWN = 0,
    GLOBAL_HIGH_SCORE,
    LOCAL_HIGH_SCORE
};

typedef struct {
    char *name;
    int score;
    enum HIGH_SCORE_SOURCE source;
} high_score_t;

extern high_score_t high_score_item[NUM_HIGH_SCORE_ITEMS];

BOOL is_new_high_score(const int score);
void update_high_score(const char *name, const int score,
		       enum HIGH_SCORE_SOURCE source);

void write_high_scores(void);
void read_high_scores(void);

#endif
