/* -*- ObjC -*- */
#ifndef __included_widget_slider_h
#define __included_widget_slider_h

#include "gui/gui.h"

@interface Slider: Widget
{
    int handle_pos, slider_precision;
    int handle_w, handle_h;

    int (*pushed_proc)(Widget *widget, int msg, int data);

    BOOL draw_background;
}
- (id) setSliderPrecision:(int)precision;
- (id) setHandleW:(int)w_;
- (id) setHandleH:(int)h_;
- (id) setHandlePosition:(int)pos;

- (int) sliderHandlePosition;
- (int) sliderPrecision;
- (int) sliderLength;
- (int) sliderMin;
- (int) sliderMax;

- (double) sliderStepSize;

- (id) setDrawBackground:(BOOL)draw;
- (id) setPushedProc:(int (*)(Widget *, int, int))proc;
@end

@interface HSlider: Slider
@end

@interface VSlider: Slider
@end

#endif
