/* -*- ObjC -*- */
#ifndef __included_group_h
#define __included_group_h

#include <objc/Object.h>

@protocol Groupable
- (id) setGroup:(int)g_;
@end

#define derive_setGroup(num)						\
	(id) setGroup:(int)g_						\
	{ num = g_; return self; }

/*------------------------------------------------------------*/

@interface UnitGroup: Object
{
    int group_id;
    int member_count;
}
- initWithID:(int)num;
- (int) groupID;
- (void) incrementGroupRef;
- (BOOL) dropGroupRef;
@end

UnitGroup *getGroupRef(int group_id);

void unit_group_init(void);
void unit_group_shutdown(void);

#endif
