/* -*- ObjC -*- */
#ifndef __included_demo_h
#define __included_demo_h

#include <allegro.h>
#include "mmpk.h"

#define DEMO_LEVEL_INIT_STRLEN	5
#define DEMO_LEVEL_INIT_STRING	"[map]"

#define DEMO_GAME_INIT_STRLEN	6
#define DEMO_GAME_INIT_STRING	"[game]"

#define DEMO_CHECKPOINT_STRLEN	6
#define DEMO_CHECKPOINT_STRING	"[sync]"

enum DEMO_STATE {
    DEMO_NOT_ACTIVE,
    DEMO_RECORDING,

    /* Demo started by player. */
    DEMO_PLAYBACK,

    /* Demo started by menu due to idleness. */
    DEMO_PLAYBACK_AUTOMATIC
};

enum DEMO_SKIP_STATE {
    DEMO_NO_SKIP,
    DEMO_SKIP_TO_NEW_SEGMENT,
    DEMO_SKIP_TO_NEW_MAP
};


extern BOOL record_demos, record_demo_checkpoint;
extern enum DEMO_STATE demo_state;
extern PACKFILE *current_demo_file;
extern MEMORY_FILE demo_file;


void read_header(MEMORY_FILE *fp);
void write_header(PACKFILE *fp);

BOOL read_level_init(MEMORY_FILE *fp, BOOL read_marker);
void write_level_init(PACKFILE *fp);

void read_game_init(MEMORY_FILE *fp);
void write_game_init(PACKFILE *fp, const long seed);

void write_demo_checkpoint(PACKFILE *fp);
void read_demo_checkpoint(MEMORY_FILE *fp);

enum DEMO_SKIP_STATE demo_skip_segment(MEMORY_FILE *fp);

PACKFILE *open_demo_file_for_recording(void);
MEMORY_FILE *open_demo_file_for_playback(const char *filename);

void close_demo_file(void);

#endif
