/* -*- ObjC -*- */
#ifndef __included_common_h
#define __included_common_h

#include <objc/Object.h>
#include "maybe-alrand.h"
#include "seborrhea/container-file.h"

#define GAME_NAME		"Raid'em"
#define GAME_VERSION		"0.3.1"
#define GAME_NAME_AND_VERSION	GAME_NAME " " GAME_VERSION
#define GAME_SPEED		50
#define SECONDS			GAME_SPEED

/* #define screen_w	320 */
#define screen_w	352	/* Extra half a tile. */
#define screen_h	480
#define status_w	((640 - screen_w) / 2)
#define status_h	230

#ifdef __MINGW__
# define HOME_PATH_ENV		"APPDATA"
# define RAIDEM_CONFIG_PATHNAME	"raidem"
#else
# define HOME_PATH_ENV		"HOME"
# define RAIDEM_CONFIG_PATHNAME	".raidem"
#endif

#define elif		else if
#define not		!

#define FREE_BITMAP(b)		if (b) { destroy_bitmap(b); b = NULL; }
#define FREE_SEBFILE(s)		if (s) s = [s free]

#define deg2rad(theta)		((theta) * M_PI/180.0)
#define rad2deg(theta)		((theta) * 180.0/M_PI)
#define rad2fix(theta)		(-ftofix((theta) * 128.0/M_PI))

#define clear_to_mask_colour(b)		(clear_to_color(b, bitmap_mask_color(b)))
#define rect_wh(b,x,y,w,h,c)		rect(b,x,y,x+w-1,y+h-1,c)
#define rectfill_wh(b,x,y,w,h,c)	rectfill(b,x,y,x+w-1,y+h-1,c)

#define streq(a,b)		(strcmp(a,b) == 0)
#define strneq(a,b)		(strcmp(a,b) != 0)

#define SQ(alpha)			((alpha) * (alpha))


/* Game state related flags. */
#define FLAG_GAME_PAUSED	0x0001	/* And confirm quit. */
#define FLAG_PLAYERS_ALIVE	0x0002
#define FLAG_QUIT		0x0004
#define FLAG_LEVEL_COMPLETE	0x0008

/* Miscellaneous flags. */
#define FLAG_REDRAW		0x0010
#define FLAG_REDRAW_SIDEBARS	0x0020
#define FLAG_REDRAW_STATUSBARS	0x0040

#define FLAG_DRAW_SHADOW	0x0100
#define FLAG_SCREEN_SHAKE	0x0200
#define FLAG_DRAW_FPS		0x0400

#define FLAG_PLAYER1_HIGH_SCORE	0x1000
#define FLAG_PLAYER2_HIGH_SCORE	0x2000
#define FLAG_PLAYER1_DEMO_NAME	0x4000
#define FLAG_PLAYER2_DEMO_NAME	0x8000

#define rnd_with_rng(l,u)	rnd_with_state(l,u,rng_state)


/* extern int game_time; */
extern SebFile *base_sebum;
extern int game_flags;
extern char *homedir;
extern char *raid_binary_directory;
extern alrand_state *rng_state;


#if ALLEGRO_DATE < 20050116
# define textout_ex(bmp,font,str,x,y,c,bg)	textout(bmp,font,str,x,y,c)
#endif

inline int rnd(const int a, const int b);
inline int rnd_with_state(const int a, const int b, alrand_state *state);
inline void simplify_angle(double *theta);

#endif
