/* -*- ObjC -*- */
#ifndef __included_candy_h
#define __included_candy_h

#include "thing.h"

#define TOTAL_CANDY_LEVELS	5
#define SPAWN_CANDY(c,x,y,l)	(c *)spawn_candy([c class], x, y, l)

extern int candy_amount;	/* Amount of eye-candy to spawn. */

enum CANDY_LAYER {
    SUBTERRANIAN_LAYER,		/* Stars. */
    FLOOR_LAYER,		/* On the floor. */
    LOW_LAYER,			/* Above ground units. */
    MEDIUM_LAYER,		/* Below air units. */
    HIGH_LAYER,			/* Above air units. */
    TOTAL_LAYERS
};

struct BITMAP;

@interface Candy: Thing
{
    double angle, speed;

    /* We want to use xv, yv to minimise using sin and cos routines. */
    double xv, yv;
    BOOL recalculate_velocity;
}
- (id) setAngle:(double)theta;
@end

@interface AnimatedCandyNoLoop: Candy
@end

void draw_candy(BITMAP *dest, enum CANDY_LAYER layer);
void update_candy(void);
Candy *spawn_candy(Class class, int x, int y, enum CANDY_LAYER layer);

void candy_init(void);
void candy_shutdown(void);

#endif
