/* To be included in wjoydx.c.
 *
 * Original force feedback code by Marcello Basta-Forte.
 *
 * 2006-01-28: Updated to work with Allegro 4.2.
 */

#include "diutil.h"
#include "allegro/platform/winff.h"

int ff_joystick_has(int n) {
	return DIUtil_IsForceFeedback( dinput_joystick[n].device );
}
FFEFFECT * ff_create_effect() {
	if (dinput_joy_num==0) return NULL;
	return DIUtil_CreateEffect();
}
void ff_destroy_effect(FFEFFECT *f) {
	if (dinput_joy_num==0) return;
	DIUtil_DeleteEffect(f);
}
int ff_play_effect(FFEFFECT *f) {
	if (dinput_joy_num==0) return -1;
	if (FAILED(DIUtil_PlayEffect(f))) return -1;
	return 0;
}
int ff_play_dir_effect(FFEFFECT *f, long direction) {
	if (dinput_joy_num==0) return -1;
	if (FAILED(DIUtil_PlayDirectionalEffect(f,direction))) return -1;
	return 0;
}
int ff_make_periodic_effect(int n, FFEFFECT *f) {
	if (dinput_joy_num==0) return -1;
	if (FAILED(DIUtil_SetupPeriodicEffect(f,dinput_joystick[n].device))) return -1;
	return 0;
}
int ff_make_constant_force_effect(int n, FFEFFECT *f, int fudge) {
	if (dinput_joy_num==0) return -1;
	if (FAILED(DIUtil_SetupConstantForceEffect(f,dinput_joystick[n].device,fudge?TRUE:FALSE))) return -1;
	return 0;
}
int ff_make_fire_force_effect(int n, FFEFFECT *f) {
	if (dinput_joy_num==0) return -1;
	if (FAILED(DIUtil_SetupFireForceEffect(f,dinput_joystick[n].device))) return -1;
	return 0;
}
