#include<string.h>
#include<allegro.h>
#include"graph.h"   // graphics
#include"error.h"
#include"game.h"
#include"consts.h"
#include"player.h"
#include"globals.h"

void PLAYER::init()
{
 image=(BITMAP*)graph[ship00].dat;
 back=create_bitmap((int)(image->w*2),(int)(image->h*2));
 if(back==NULL) gen_error(ERR_MEMORY);
 clear(back);
 imgw=image->w/2;
 imgh=image->h/2;
 backw=back->w/2;
 backh=back->h/2;
 spr_size=image->w/2;

 shoot_time[0]=10;
 shoot_time[1]=12;
 shoot_time[2]=20;
 shoot_time[3]=20;
 shoot_time[4]=30;
 shoot_time[5]=60;
 shoot_time[6]=120;
 shoot_time[7]=28;
 shoot_time[8]=47;
 shoot_time[9]=53;

 x=0; y=0;
 xn=0; yn=0;
 ang=0;
 hp=100;
 score=0;
 lives=5;
 upgr=0;
 for(int n=0;n<max_upgr;n++)
 {
  shot[n]=0;
 }
 active=1;
}
void PLAYER::deinit()
{
 destroy_bitmap(back);
}

void PLAYER::respawn()
{
 x=rand()%level->w;
 y=rand()%level->h;
 xn=0;
 yn=0;
 ang=rand()%256;
 hp=100;
 for(int n=0;n<max_upgr;n++)
  shot[n]=0;
}

void PLAYER::die()
{
 lives--;
 if(lives<0)
 {
  lives=0;
  active=0;
 }
 create_explo(x,y,1,50);
 create_explo(x+rand()%10,y+rand()%10,1,20+rand()%10);
 create_explo(x+rand()%10,y+rand()%10,1,10+rand()%10);
 respawn();
}

void PLAYER::accel(fix n)
{
 xn+=cos(ang)*(0.05*n);
 yn+=sin(ang)*(0.05*n);
}
void PLAYER::turn(fix n)
{
 ang+=2*n;
}
void PLAYER::update()
{
 for(int n=0;n<max_upgr;n++)
  if(shot[n]>0) shot[n]--;
 x+=xn;
 y+=yn;
}

void shoot1(PLAYER *pl)
{
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang,0,pl->num);
}
void shoot2(PLAYER *pl)
{
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang-4,0,pl->num);
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang+4,0,pl->num);
}
void shoot3(PLAYER *pl)
{
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang,1,pl->num);
}
void shoot4(PLAYER *pl)
{
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang+64,3,pl->num);
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang-64,3,pl->num);
}
void shoot5(PLAYER *pl)
{
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang-8,0,pl->num);
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang,2,pl->num);
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang+8,0,pl->num);
}
void shoot6(PLAYER *pl)
{
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang+128,4,pl->num);
}
void shoot7(PLAYER *pl)
{
 for(int n=0;n<29;n++)
 {
  create_bullet(pl->x,pl->y,pl->xn,pl->yn,n*8.8,5,pl->num);
 }
}
void shoot8(PLAYER *pl)
{
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang-12,0,pl->num);
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang-4,1,pl->num);
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang+4,1,pl->num);
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang+12,0,pl->num);
}
void shoot9(PLAYER *pl)
{
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang,4,pl->num);
}
void shoot10(PLAYER *pl)
{
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang-4,2,pl->num);
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang,2,pl->num);
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang+4,2,pl->num);
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang+62,3,pl->num);
 create_bullet(pl->x,pl->y,pl->xn,pl->yn,pl->ang-62,3,pl->num);
}


void PLAYER::shoot()
{
 for(int n=0;n<max_upgr;n++)
 {
  if(shot[n]<=0 && upgr>=n)
  {
   shot[n]=shoot_time[n];
   if(n==0) shoot1(this);
   if(n==1) shoot2(this);
   if(n==2) shoot3(this);
   if(n==3) shoot4(this);
   if(n==4) shoot5(this);
   if(n==5) shoot6(this);
   if(n==6) shoot7(this);
   if(n==7) shoot8(this);
   if(n==8) shoot9(this);
   if(n==9) shoot10(this);
  }
 }
}


