//Macros & Defines///////////////////////////////////////////////////////////
#define GAME_SPEED 90
#define NUM_SNOWFLAKES 1000

#define DEG(n)    ((n) * 180.0 / M_PI)
#define RAD(n)    ((n) / (180.0 / M_PI))

#define UP    0
#define DOWN  1
#define RIGHT 2
#define LEFT  3

//Enums//////////////////////////////////////////////////////////////////////
enum snowfight_state { state_title, state_game, state_paused };

//Classes & Structs//////////////////////////////////////////////////////////
struct snowflake
{
  float x, y, dx, dy, amp;
  int c;

  void init();
  void move();
  void draw();
};

struct snow_ball
{
  float x, y, z, dy, speed, heading, pitch, ice;
  char exploding, visible;

  void processing();
  void hide();
  void launch(float x, float y, float z, float heading, float pitch, float speed, float ice);
  void explode();
};

struct player
{
  float x, y, z, life, power, heading, snow_amt, ice_amt, stand_height, dy,
        speed, _pitch;
  unsigned char current, direction;
  char is_in_tri, launched, visible;
  unsigned int count;
  snow_ball ball;

  player();
  void fire();
  void power_up();
  void gather_snow();
  void set(float x, float y, float z);
  void ai();
  void launch(float heading, float pitch, float speed);
  void hide();
};

//Externs////////////////////////////////////////////////////////////////////
extern WORLD *world;
extern MODEL_3D *snowball, *snowmesh;
extern DATAFILE *data, *textures;
extern BITMAP *buffer, *snow_blast[4], *man_sprites[2];
extern JGMOD *music;
extern player players[60];
extern snowfight_state game_state;
extern snowflake snowflakes[NUM_SNOWFLAKES];
extern int viewport_w, viewport_h, fpscounter, a_fps, disp_fps, NUM_PLAYERS;
extern char show_fps, god_mode;
extern volatile int fps;

//Prototypes/////////////////////////////////////////////////////////////////
void fps_proc();
void snowfight_init();
void snowfight_loop();
void snowfight_shutdown();
void ls_logo();
void fatal_error(char *msg = "Out of memory!");


