#include "allegro.h"
#include <jgmod.h>
#include <p3d.h>
#include <math.h>
#include "/re/3dlib.h"
#include "snowdat.h"
#include "snow.h"

//Globals////////////////////////////////////////////////////////////////////
char *diff_levels[4] = { "Easy", "Medium", "Hard", "Insane!" };
char game_exit = FALSE, z_buffering = FALSE, difficulty = 0, cy = 0;
unsigned char title_a, m_state = 0, s_state;
short blood_a = 0;
snowflake snowflakes[NUM_SNOWFLAKES];
float snowflake_t = 0.0, cam_x, cam_y, cam_z, heading = 0.0,
      pitch = 0, roll = 0;

quad man_quad = { { { 5, -8.5, -5 }, { 5, -8.5, 5 }, { 5, 8.5, 5 }, { 5, 8.5, -5 } }, &man_sprites[0], -1, TRUE, POLYTYPE_PTEX_MASK, 0, 0, 0, 0, 0, 0 };

//Prorotypes/////////////////////////////////////////////////////////////////
void return_to_menu();
void input();
void process();
void game_process();
void test_player_collision();
void output();
void render(BITMAP *bmp);
void credits();
void credits_fade_out(int black = FALSE);
void cool_effect(int x, int y, char *str, int off = TRUE);
void point_at_camera(float x, float y, float z, float *heading);
void point_away_from(int id, float x, float y, float z, float *heading);
void draw_bar(int x, int y, int wt, int ht, float val, int back_c, int fore_c, char *str);
inline float p_distance(float x1, float y1, float x2, float y2);
inline float p_distance3d(float x1, float y1, float z1, float x2, float y2, float z2);
int collide(float x1, float z1, float x2, float z2, float wt1, float ln1, float wt2, float ln2);
int collide3d(float x1, float y1, float z1, float x2, float y2, float z2, float wt1, float ht1, float ln1, float wt2, float ht2, float ln2);
//int in_quad(V3D_f p, V3D_f v[4]);

//Functions//////////////////////////////////////////////////////////////////
void snowfight_loop()
{
  fps = fpscounter = a_fps = 0;
  disp_fps = GAME_SPEED;
  clear_keybuf();

  while(!game_exit)
  {
    input();
    process();
    if(fpscounter >= fps) output();
    while(fpscounter > fps) {}
  }
  remove_int(fps_proc);
  stop_mod();
  scene_start(buffer, 0, 0);
}

void return_to_menu()
{
  game_state = state_title;
  delete world;
  delete snowball;
  delete snowmesh;
}

void input()
{
  if(key[KEY_F10])
  {
    blit(screen, buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
    save_bitmap("screenshot.bmp", buffer, NULL);
  }

  switch(game_state)
  {
    case state_title:
			if(key[KEY_DOWN])
      {
        cy++;
        if(cy > 2) cy = 0;
      }
      if(key[KEY_UP])
      {
        cy--;
        if(cy < 0) cy = 2;
      }
      if(cy == 0)
      {
  			if(key[KEY_RIGHT])
        {
          difficulty++;
          if(difficulty > 3) difficulty = 0;
        }
        if(key[KEY_LEFT])
        {
          difficulty--;
          if(difficulty < 0) difficulty = 3;
        }
      }
      if(key[KEY_ENTER])
      {
        if(cy == 1)
        {
          int i;

          switch(difficulty)
          {
            case 0: NUM_PLAYERS = 5; break;
            case 1: NUM_PLAYERS = 15; break;
            case 2: NUM_PLAYERS = 25; break;
            case 3: NUM_PLAYERS = 60; break;
          }
          title_a = 255;
          game_state = state_game;
          textout(screen, font, "Loading..", SCREEN_W-100, SCREEN_H-8, 0);
          world = new WORLD();
          if(!world) fatal_error();
          world->set_view_distance(5000);
          world->load("snow.wld", textures, &cam_x, &cam_y, &cam_z);
          snowball = new MODEL_3D("sphere.3do");
          if(!snowball) fatal_error();
          snowball->set_texture((BITMAP *) textures[0].dat);
          snowball->set_type(POLYTYPE_PTEX);
          snowball->resize(2.5);
          snowmesh = new MODEL_3D("snow.3do");
          if(!snowmesh) fatal_error();
          snowmesh->set_texture(snow_blast[0]);
        //  snowmesh->set_pos(cam_x, -8.5, cam_z);
          snowmesh->set_type(POLYTYPE_PTEX_MASK);
          snowmesh->resize(2.5);
          cam_y = -8.5;
          players[0].set(cam_x, cam_y, cam_z);
          for(i = 1; i < NUM_PLAYERS; i++)
            players[i].set((float)((random()%440)+110), 0, (float)((random()%400)+90));
          clear_keybuf();
        }
        if(cy == 2) game_exit = TRUE;
      }
      if(key[KEY_ESC]) cy = 2;
      clear_keybuf();
    break;
    case state_game:
      if(key[KEY_ESC])
      {
        return_to_menu();
        clear_keybuf();
      }
      if(players[0].life <= 0.0) return;
      if(mouse_b & 1)
      {
        if(!players[0].ball.visible)
        {
          m_state = 1;
          players[0].power_up();
        }
      }
      else if(m_state != 0) { players[0].fire(); m_state = 0; }
      if(key[KEY_SPACE] && m_state != 1)
      {
        s_state = 1;
        players[0].gather_snow();
        if(players[0].stand_height < -4.0) players[0].stand_height += 0.25;
      }
      else if(s_state != 0)
      {
        if(players[0].stand_height > -8.5) players[0].stand_height -= 0.25;
      }
      if(key[KEY_UP])
      {
        players[0].x += sin(heading)/((mouse_b & 2) ? 1 : 2);
        players[0].z += cos(heading)/((mouse_b & 2) ? 1 : 2);
      }
      if(key[KEY_DOWN])
      {
        players[0].x -= sin(heading)/((mouse_b & 2) ? 1 : 2);
        players[0].z -= cos(heading)/((mouse_b & 2) ? 1 : 2);
      }
      if(key[KEY_LEFT])
      {
        players[0].x -= sin(heading+(M_PI/2))/2;
        players[0].z -= cos(heading+(M_PI/2))/2;
      }
      if(key[KEY_RIGHT])
      {
        players[0].x += sin(heading+(M_PI/2))/2;
        players[0].z += cos(heading+(M_PI/2))/2;
      }
      if(key[KEY_Z])
      {
        if(z_buffering) { world->set_z_buffer(FALSE); z_buffering = FALSE; }
        else { world->set_z_buffer(TRUE); z_buffering = TRUE; }
        clear_keybuf();
      }
    break;
    default:
    break;
  }
}

void process()
{
  int i;

  fpscounter++;
  if(fpscounter % GAME_SPEED == 0)
  {
    disp_fps = a_fps;
    a_fps = 0;
  }

  //Move snow
  snowflake_t += 0.01;
  for(i = 0; i < NUM_SNOWFLAKES; i++) snowflakes[i].move();

  switch(game_state)
  {
    case state_title:
      if(title_a < 255) title_a++;
    break;
    case state_game:
      game_process();
    break;
    default:
    break;
  }
}

void game_process()
{
  int mx, my, i, num_down = 0;

  if(players[0].launched) players[0].ai();
  if(players[0].life <= 0.0 && players[0].stand_height < -2.0)
    players[0].stand_height += 0.1;
  if(blood_a && players[0].life > 0.0) blood_a -= 2;
  if(blood_a < 0) blood_a = 0;
  if(players[0].life > 0.0)
  {
    get_mouse_mickeys(&mx, &my);
    pitch += (float)my/150;
    heading += (float)mx/150;
  }

  if(pitch <= -M_PI/3) pitch = -M_PI/3;
  if(pitch >= M_PI/3) pitch = M_PI/3;

  test_player_collision();

  for(i = 0; i < NUM_PLAYERS; i++)
  {
    int j;
    char set_y = FALSE;

    if(!players[i].launched)
    {
      if(players[i].x < 100.5) players[i].x = 100.5;
      if(players[i].x > 599.5) players[i].x = 599.5;
      if(players[i].z < 75.5) players[i].z = 75.5;
      if(players[i].z > 574.5) players[i].z = 574.5;
    }
    if(i > 0) players[i].ai();
    if(players[i].launched)
    {
      if(!players[i].visible) num_down++;
      continue;
    }

    for(j = 0; j < world->get_num_tri(); j++)
    {
      V3D_f v = { players[i].x, players[i].y, players[i].z };
      if(world->in_tri(&v, j))
      {
        players[i].is_in_tri = TRUE;
        set_y = TRUE;
        players[i].y = world->find_int(&v, j) + players[i].stand_height;
      }
    }
    if(!set_y)
    {
      players[i].y = players[i].stand_height;
      players[i].is_in_tri = FALSE;
    }
  }
  if(num_down == NUM_PLAYERS-1 || 1)
  {
    BITMAP *temp = create_bitmap(SCREEN_W, SCREEN_H);
    char *msg = "Goooooooood!";

    if(!temp) fatal_error();
    switch(difficulty)
    {
      case 2:
        msg = "God Mode Turned On!!!!!!!!";
        goto skip;
      case 3:
        if(players[0].launched) break;
        msg = "Think you can cheat your way to the top????";
      case 0:
        skip:
        blit(screen, temp, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
        fpscounter = fps = 0;
        drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
        for(i = 0; i < 128; i++)
        {
          fpscounter++;
          if(fpscounter >= fps)
          {
            blit(temp, buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
            set_trans_blender(0, 0, 0, i);
            rectfill(buffer, 0, 0, SCREEN_W, SCREEN_H, makecol(0, 0, 255));
            blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
          }
          while(fpscounter > fps) {}
        }
        solid_mode();
        textout_centre(screen, font, msg, SCREEN_W/2+1, SCREEN_H/2+1, makecol(100, 0, 0));
        textout_centre(screen, font, msg, SCREEN_W/2, SCREEN_H/2, makecol(255, 0, 0));
        clear_keybuf();
        readkey();
        if(difficulty == 2) god_mode = TRUE;
        if(difficulty == 3)
        {
          players[0].launch(players[0].heading, -M_PI/3, 2.0);
          fps = fpscounter = 0;
        }
        else return_to_menu();
        clear_keybuf();
      break;
      case 1:
        blit(screen, temp, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
        fpscounter = fps = 0;
        drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
        for(i = 0; i < 255; i++)
        {
          fpscounter++;
          if(fpscounter >= fps)
          {
            blit(temp, buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
            set_trans_blender(0, 0, 0, i);
            rectfill(buffer, 0, 0, SCREEN_W, SCREEN_H, 0);
            blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
          }
          while(fpscounter > fps) {}
        }
        solid_mode();
        credits();
        title_a = 0;
        return_to_menu();
        clear_keybuf();
      break;
    }
    destroy_bitmap(temp);
  }
  for(i = 0; i < NUM_PLAYERS; i++) if(players[i].ball.visible)
    players[i].ball.processing();
}

void test_player_collision()
{
  int i;

  for(i = 1; i < NUM_PLAYERS; i++)
  {
    if(collide(players[0].x, players[0].z, players[i].x, players[i].z, 1, 1, 10, 10))
    {
      if(key[KEY_UP])
      {
        players[0].x -= sin(heading)/((mouse_b & 2) ? 1 : 2);
        players[0].z -= cos(heading)/((mouse_b & 2) ? 1 : 2);
      }
      if(key[KEY_DOWN])
      {
        players[0].x += sin(heading)/((mouse_b & 2) ? 1 : 2);
        players[0].z += cos(heading)/((mouse_b & 2) ? 1 : 2);
      }
    }
  }
}

void output()
{
  int i;

  a_fps++;
  cam_x = players[0].x;
  cam_y = players[0].y;
  cam_z = players[0].z;
  switch(game_state)
  {
    case state_title:
      if(SCREEN_W == 640 && SCREEN_H == 480) blit((BITMAP *) data[title].dat, buffer, 0, 0, 0, 0, 640, 480);
      else stretch_blit((BITMAP *) data[title].dat, buffer, 0, 0, 640, 480, 0, 0, SCREEN_W, SCREEN_H);
      textprintf_centre(buffer, font, SCREEN_W/2, SCREEN_H-100, (cy == 0) ? makecol(255, 0, 0) : makecol(100, 100, 100), "Difficulty: %s", diff_levels[difficulty]);
      textout_centre(buffer, font, "Start", SCREEN_W/2, SCREEN_H-90, (cy == 1) ? makecol(255, 0, 0) : makecol(100, 100, 100));
      textout_centre(buffer, font, "Exit", SCREEN_W/2, SCREEN_H-80, (cy == 2) ? makecol(255, 0, 0) : makecol(100, 100, 100));
    break;
    case state_game:
      render(buffer);
    break;
    default:
    break;
  }

  if(show_fps)
  {
    textprintf(buffer, font, SCREEN_W-75, 0, makecol(255, 255, 255), "Fps: %u", disp_fps);
    textprintf(buffer, font, SCREEN_W-75, 10, makecol(255, 255, 255), "Zbuf: %s", z_buffering ? "On" : "Off");
  }
  for(i = 0; i < NUM_SNOWFLAKES; i++) snowflakes[i].draw();
  if(game_state == state_game)
  {
    vline(buffer, SCREEN_W/2, (SCREEN_H/2)-20, (SCREEN_H/2)+20, makecol(255, 0, 0));
    hline(buffer, (SCREEN_W/2)-20, SCREEN_H/2, (SCREEN_W/2)+20, makecol(255, 0, 0));
    draw_bar(5, 5, 200, text_height(font)+15, players[0].life, makecol(75, 0, 0), makecol(255, 0, 0), "Life");
    draw_bar(5, 25, 200, text_height(font)+15, players[0].snow_amt, makecol(0, 75, 75), makecol(0, 200, 200), "Snow");
    draw_bar(5, 45, 200, text_height(font)+15, players[0].ice_amt, makecol(0, 0, 100), makecol(200, 200, 200), "Ice");
    if(players[0].power > 0.0)
      draw_bar((SCREEN_W/2)-50, SCREEN_H-30, 100, text_height(font)+15, players[0].power, makecol(0, 0, 75), makecol(0, 100, 255), "Power");
    if(blood_a)
    {
      set_trans_blender(0, 0, 0, blood_a);
      drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
      rectfill(buffer, 0, 0, SCREEN_W, SCREEN_H, makecol(255, 0, 0));
      solid_mode();
    }
  }
  if(title_a < 255 && game_state == state_title)
  {
    set_trans_blender(0, 0, 0, 255-title_a);
    drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
    rectfill(buffer, 0, 0, SCREEN_W, SCREEN_H, 0);
    solid_mode();
  }
  blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}

void snowflake::init()
{
  x = (float) (random()%SCREEN_W);
  y = (float) (random()%SCREEN_H);
  dx = (random()%50)/10.0;
  dy = ((random()%50)+5)/10.0;
  amp = (random()%25)/10.0;
  c = (random()%100) + 155;
}

void snowflake::move()
{
  x += dx;
  y += dy;
  x += sin(snowflake_t)*amp;

  if(x > SCREEN_W) x = 0;
  if(y > SCREEN_H) y = 0;
}

player::player()
{
  set(0, 0, 0);
}

void player::fire()
{
  if(power == 0.0) return;
  ball.launch(x, y, z, ::heading, pitch, power*2, ice_amt);
  power = 0.0;
}

void player::power_up()
{
  if(power >= 1.0) { power = 1.0; return; }
  if(ice_amt > 0.0) ice_amt -= 0.004;
  else ice_amt = 0;
  if(snow_amt > 0.0) snow_amt -= 0.002;
  else { snow_amt = 0.0; return; }
  power += 0.0065;
}

void player::gather_snow()
{
  snow_amt += 0.002;
  if(snow_amt > 1.0) snow_amt = 1.0;
  if(is_in_tri) ice_amt += 0.001;
  if(ice_amt > 1.0) ice_amt = 1.0;
}

void player::set(float x, float y, float z)
{
  snow_amt = 0.5;
  ice_amt = 0.0;
  life = 1.0;
  direction = DOWN;
  current = 0;
  is_in_tri = launched = FALSE;
  visible = TRUE;
  stand_height = -8.5;
  ball.hide();
  count = random()%90;
  this->x = x;
  this->y = y;
  this->z = z;
}

void player::ai()
{
  count++;

  //Walk at player
  if(launched)
  {
    if(this == &players[0])
    {
      x -= sin(heading)*speed;
      y += sin(_pitch)*speed;
      z -= cos(heading)*speed;
    }
    else
    {
      x += sin(heading)*speed;
      y += sin(_pitch)*speed;
      z -= cos(heading)*speed;
    }
    y += dy;
    dy += 0.005;
    speed -= 0.001;
    if(speed < 0) speed = 0;
    if(y > 0.0) hide();
  }
  else
  {
    if(players[0].life > 0)
    {
      if(p_distance(x, z, cam_x, cam_z) > 15)
      {
        int i, too_close = FALSE;
    
        for(i = 1; i < NUM_PLAYERS; i++) if(&players[i] != this)
        {
          if(p_distance(x, z, players[i].x, players[i].z) < 30)
          {
            too_close = TRUE;
            point_away_from(i, x, y, z, &heading);
            x -= sin(heading)/2;
            z += cos(heading)/2;
          }
        }
        point_at_camera(x, y, z, &heading);
        if(!too_close)
        {
          x -= sin(heading)/2;
          z += cos(heading)/2;
        }
      }
      else if(count % 90 == 0)
      {
        unsigned short freq = 1000;
    
        blood_a = 128;
        if(!god_mode) players[0].life -= 0.15;
        if(players[0].life < 0)
        {
          freq = 500;
          players[0].life = 0.0;
        }
        play_sample((SAMPLE *)data[hit_sound].dat, 255, 128, freq, FALSE);
      }
    }
    if(fpscounter % 20 == 0)
    {
      if(direction == DOWN)
      {
        if(current == 0) current = 1;
        else current = 0;
      }
    }
  }
}

void player::launch(float heading, float pitch, float speed)
{
  launched = TRUE;
  this->heading = heading;
  this->_pitch = pitch;
  this->speed = speed;
  dy = 0.0;
}

void player::hide()
{
  visible = FALSE;
}

void snow_ball::launch(float x, float y, float z, float heading, float pitch, float speed, float ice)
{
  this->x = x;
  this->y = y;
  this->z = z;
  this->heading = heading;
  this->pitch = pitch;
  this->speed = speed;
  this->ice = ice;
  visible = TRUE;
  dy = 0.0;
  exploding = 0;
}

void snow_ball::processing()
{
  float ground;
  int i, set_y;

  if(exploding)
  {
    if(fpscounter % 5 == 0) exploding++;
    if(exploding == 5) hide();
  }
  else
  {
    for(i = 1; i < NUM_PLAYERS; i++)
    {
      if(collide3d(x, y, z, players[i].x, players[i].y, players[i].z, 6.0, 6.0, 6.0, 5.0, 17.5, 5.0))
      {
        explode();
        players[i].life -= ((speed/2)*0.4)+(ice*0.6);
        if(players[i].life < 0.0)
        {
          players[i].life = 0.0;
					players[i].launch(players[i].heading, -M_PI/3, 2.0);
        }
      }
    }
    for(i = 0; i < world->get_num_tri(); i++)
    {
      V3D_f v = { x, y, z };
      if(world->in_tri(&v, i))
      {
        set_y = TRUE;
        ground = world->find_int(&v, i);
      }
    }
    if(!set_y) ground = 0.0;
  
    x += sin(heading)*speed;
    y += sin(pitch)*speed;
    z += cos(heading)*speed;
    y += dy;
    dy += 0.005;
    speed -= 0.001;
    if(speed < 0) speed = 0;
    if(x < 100.5 || x > 599.5 || z < 75.5 || z > 574.5 || y > ground-1) explode();
  }
}

void snow_ball::hide()
{
  visible = FALSE;
}

void snow_ball::explode()
{
  short vol = 255-(int)(p_distance3d(cam_x, cam_y, cam_z, x, y, z));
  if(vol < 0) vol = 0;

  play_sample((SAMPLE *)data[snowblast_sound].dat, vol, 128, 1000, FALSE);
  exploding = 1;
}

void snowflake::draw()
{
  putpixel(buffer, (int)x, (int)y, makecol(c, c, 255));
}

void render(BITMAP *bmp)
{
   MATRIX_f roller, camera;
   int x, y, w, h, i;
   float xfront, yfront, zfront;
   float xup, yup, zup;

   if(SCREEN_W == 640 && SCREEN_H == 480) blit((BITMAP *) textures[2].dat, buffer, 0, 0, 0, 0, 640, 480);
   else stretch_blit((BITMAP *) textures[2].dat, buffer, 0, 0, 640, 480, 0, 0, SCREEN_W, SCREEN_H);

   x = 0;
   y = 0;
   w = bmp->w;
   h = bmp->h;

   set_projection_viewport(x, y, w, h);

   xfront = sin(heading) * cos(pitch);
   yfront = sin(pitch);
   zfront = cos(heading) * cos(pitch);

   get_vector_rotation_matrix_f(&roller, xfront, yfront, zfront, roll*128.0/M_PI);
   apply_matrix_f(&roller, 0, -1, 0, &xup, &yup, &zup);

   get_camera_matrix_f(&camera,
		       cam_x, cam_y, cam_z,
		       xfront, yfront, zfront,
		       xup, yup, zup,
		       48,
		       1);
   scene_start(bmp, 20000, 5000);
   zbuf_start(bmp, 0.0);

   world->render(&camera, cam_x, cam_y, cam_z);
   for(i = 0; i < NUM_PLAYERS; i++) if(players[i].visible)
   {
     if(i > 0)
     {
       float ry = (DEG(players[i].heading)*0.71111111)+64;

       man_quad.x = players[i].x;
       man_quad.y = players[i].y;
       man_quad.z = players[i].z;
       man_quad.text = &man_sprites[players[i].current];

       draw_quad(&camera, man_quad, man_quad.x, man_quad.y, man_quad.z, 0, ry, 0);
     }
     if(!players[i].ball.visible) continue;
     if(!players[i].ball.exploding)
     {
       snowball->set_pos(players[i].ball.x, players[i].ball.y, players[i].ball.z);
       snowball->draw(&camera);
     }
     else
     {
       snowmesh->set_pos(players[i].ball.x, players[i].ball.y, players[i].ball.z);
       snowmesh->set_texture(snow_blast[players[i].ball.exploding-1]);
       snowmesh->draw(&camera);
     }
   }
   scene_render();

   zbuf_start(NULL, 0.0);
}

void credits()
{
  stretch_blit((BITMAP *)textures[0].dat, buffer, 0, 0, 512, 512, 0, 0, SCREEN_W, SCREEN_H);
  cool_effect(SCREEN_W/2, SCREEN_H/2, "Credits");
  cool_effect(SCREEN_W/2, SCREEN_H/2-20, "-Programming/2D 3D Artwork/Sound Effects-", FALSE);
  cool_effect(SCREEN_W/2, SCREEN_H/2-12, "-Realm3D Engine/Game Design-", FALSE);
  cool_effect(SCREEN_W/2, SCREEN_H/2, "__Kain__ (Mike Farrell)", FALSE);
  rest(2000);
  fps = fpscounter = 0;
  credits_fade_out();
  cool_effect(SCREEN_W/2, SCREEN_H/2-12, "-E3D Model Editor and lots of 3D math help!-", FALSE);
  cool_effect(SCREEN_W/2, SCREEN_H/2, "James Higgs", FALSE);
  rest(2000);
  fps = fpscounter = 0;
  credits_fade_out();
  cool_effect(SCREEN_W/2, SCREEN_H/2-12, "-DJGPP Compiler-", FALSE);
  cool_effect(SCREEN_W/2, SCREEN_H/2, "DJ Delorie", FALSE);
  rest(2000);
  fps = fpscounter = 0;
  credits_fade_out();
  cool_effect(SCREEN_W/2, SCREEN_H/2-12, "-Allegro Game Library-", FALSE);
  cool_effect(SCREEN_W/2, SCREEN_H/2, "Shawn Hargreaves", FALSE);
  rest(2000);
  fps = fpscounter = 0;
  credits_fade_out();
  cool_effect(SCREEN_W/2, SCREEN_H/2-12, "-RHIDE 1.4 Development Environment-", FALSE);
  cool_effect(SCREEN_W/2, SCREEN_H/2, "Robert Hohne", FALSE);
  rest(2000);
  fps = fpscounter = 0;
  credits_fade_out();
  cool_effect(SCREEN_W/2, SCREEN_H/2-12, "-P3D Rendering Library-", FALSE);
  cool_effect(SCREEN_W/2, SCREEN_H/2, "Calin Andrian", FALSE);
  rest(2000);
  fps = fpscounter = 0;
  credits_fade_out();
  cool_effect(SCREEN_W/2, SCREEN_H/2-20, "-Allegro.cc Gamewriting Community-", FALSE);
  cool_effect(SCREEN_W/2, SCREEN_H/2-12, "for giving me so many web page hits :)", FALSE);
  cool_effect(SCREEN_W/2, SCREEN_H/2, "Mathew Leverton", FALSE);
  rest(2000);
  fps = fpscounter = 0;
  credits_fade_out();
  cool_effect(SCREEN_W/2, SCREEN_H/2-12, "-Useful Math Routine-", FALSE);
  cool_effect(SCREEN_W/2, SCREEN_H/2, "Ben Wyatts", FALSE);
  rest(2000);
  fps = fpscounter = 0;
  credits_fade_out();
  cool_effect(SCREEN_W/2, SCREEN_H/2-12, "-And anyone else that plays my games :)-");
  credits_fade_out(TRUE);
}

void credits_fade_out(int black)
{
  BITMAP *tmp = create_bitmap(SCREEN_W, SCREEN_H);
  short i;

  if(!tmp) fatal_error();
  stretch_blit((BITMAP *)textures[0].dat, tmp, 0, 0, 512, 512, 0, 0, SCREEN_W, SCREEN_H);
  for(i = 0; i < 255; i++)
  {
    fpscounter++;
    if(fpscounter >= fps)
    {
      set_trans_blender(0, 0, 0, i);
      if(!black) draw_trans_sprite(buffer, tmp, 0, 0);
      else
      {
        drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
        rectfill(buffer, 0, 0, SCREEN_W, SCREEN_H, 0);
        solid_mode();
      }
      blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
    }
    while(fpscounter > fps) {}
  }
  destroy_bitmap(tmp);
}

void cool_effect(int x, int y, char *str, int off)
{
  BITMAP *tmp = create_bitmap(SCREEN_W, SCREEN_H), *c = create_bitmap(8, 8);
  short a[60], done[60], len = strlen(str), i, current, go = TRUE, da = 30;

  if(!tmp) fatal_error();
  if(!c) fatal_error();
  blit(buffer, tmp, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

  fps = fpscounter = 0;
  for(i = 0; i < len; i++) a[i] = done[i] = 0;
  current = random()%len;
  while(go)
  {
    short amt_done = 0;

    fpscounter++;

    a[current]+=da;
    if(a[current] > 255) a[current] = 255;
    if(a[current] < 0) a[current] = 0;
    for(i = 0; i < len; i++) if(done[i]) amt_done++;
    if(amt_done == len)
    {
      if(da != -30 && off)
      {
        rest(2000);
        fpscounter = fps = 0;
        da = -30;
        for(i = 0; i < len; i++) done[i] = FALSE;
      }
      else go = FALSE;
    }
    if((a[current] == 255 && da == 30) || (a[current] == 0 && da == -30))
    {
      done[current] = TRUE;
      current++;
      if(current == len) current = 0;
    }
    if(fpscounter >= fps)
    {
      blit(tmp, buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
      for(i = 0; i < len; i++)
      {
        clear_to_color(c, makecol(255, 0, 255));
        textprintf(c, font, 0, 0, makecol(0, 0, 255), "%c", str[i]);
        set_trans_blender(0, 0, 0, a[i]);
        draw_trans_sprite(buffer, c, (x-((len/2)*8))+(i*8), y);
      }
      blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
    }
    while(fpscounter > fps) {}
  }
  destroy_bitmap(tmp);
  destroy_bitmap(c);
}

void point_away_from(int id, float x, float y, float z, float *heading)
{
  float xdist, ydist, radians, degrees;
  
  xdist = x - players[id].x;
  ydist = players[id].z - z;
  
  if((ydist > 0 && xdist > 0) || (ydist < 0 && xdist < 0)) radians = atan(fabs(xdist)/fabs(ydist));
  if((ydist < 0 && xdist > 0) || (ydist > 0 && xdist < 0)) radians = atan(fabs(ydist)/fabs(xdist));
  degrees = DEG(radians);
  if(ydist < 0 && xdist > 0) degrees += 90;
  if(ydist < 0 && xdist < 0) degrees += 180;
  if(ydist > 0 && xdist < 0) degrees += 270;
  *heading = RAD(degrees+180);
}

void point_at_camera(float x, float y, float z, float *heading)
{
  float xdist, ydist, radians, degrees;
  
  xdist = x - cam_x;
  ydist = cam_z - z;
  
  if((ydist > 0 && xdist > 0) || (ydist < 0 && xdist < 0)) radians = atan(fabs(xdist)/fabs(ydist));
  if((ydist < 0 && xdist > 0) || (ydist > 0 && xdist < 0)) radians = atan(fabs(ydist)/fabs(xdist));
  degrees = DEG(radians);
  if(ydist < 0 && xdist > 0) degrees += 90;
  if(ydist < 0 && xdist < 0) degrees += 180;
  if(ydist > 0 && xdist < 0) degrees += 270;
  *heading = RAD(degrees);
}

void draw_bar(int x, int y, int wt, int ht, float val, int back_c, int fore_c, char *str)
{
  rect(buffer, x, y, x+wt, y-5+ht, makecol(255, 255, 255));
  drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
  set_trans_blender(0, 0, 0, 100);
  rectfill(buffer, x+1, y+1, x+wt-1, y-5+ht-1, back_c);
  solid_mode();
  rectfill(buffer, x+2, y+2, (int)(x+2+((wt-4)*val)), y-5+ht-2, fore_c);
  textout_centre(buffer, font, str, x+(wt/2), y+5, makecol(255, 255, 255));
}

inline float p_distance(float x1, float y1, float x2, float y2)
{
  return sqrt(pow(x2-x1, 2) + pow(y2-y1, 2));
}

inline float p_distance3d(float x1, float y1, float z1, float x2, float y2, float z2)
{
  return sqrt(pow(x2-x1, 2) + pow(y2-y1, 2) + pow(z2-z1, 2));
}

int collide(float x1, float z1, float x2, float z2, float wt1, float ln1, float wt2, float ln2)
{
  return (!((((x1-(wt1/2)) > (x2+(wt2/2))) || ((x2-(wt2/2)) > (x1+(wt1/2))) || ((z1-(ln1/2)) > (z2+(ln2/2))) || ((z2-(ln2/2)) > (z1+(ln1/2))))));
}

int collide3d(float x1, float y1, float z1, float x2, float y2, float z2, float wt1, float ht1, float ln1, float wt2, float ht2, float ln2)
{
  return (!((((x1-(wt1/2)) > (x2+(wt2/2))) || ((x2-(wt2/2)) > (x1+(wt1/2))) || ((z1-(ln1/2)) > (z2+(ln2/2))) || ((z2-(ln2/2)) > (z1+(ln1/2))) || ((y1-(ht1/2)) > (y2+(ht2/2))) || ((y2-(ht2/2)) > (y1+(ht1/2))))));
}

/*int in_quad(V3D_f p, V3D_f v[4])
{
  int i, j, ret = TRUE;
  float area; 
 
  for(i=0; i<4; i++)
  { 
    j = (i+1) % 4;
    area = tri_area(p.x, p.y, v[j].x, v[j].z, v[i].x, v[i].z);
    if(area < 0.0)
    { 
      ret = FALSE;
    } 
  } 
  return ret;
}*/

