/////////////////////////////////////////////////////////////////////////////
//          --                                                             //
//          \   |\ |  /-\  \        /  /-- ___  /--  |  | ---              //
//           |  | \|  | |   \  /\  /   |--  |   | -  |--|  |               //
//         _/   |  |  \-/    \/  \/    |   ---  \ /  |  |  |               //
//_________________________________________________________________________//
//       Snowball throwing carnage Coded by Mike Farrell (__Kain__)        //
/////////////////////////////////////////////////////////////////////////////

//Includes///////////////////////////////////////////////////////////////////
#include "allegro.h"
#include <stdio.h>
#include <iostream.h>
#include <time.h>
#include <string.h>
#include <p3d.h>
#include <jgmod.h>
#include "/re/3dlib.h"
#include "snowdat.h"
#include "snow.h"

//Globals////////////////////////////////////////////////////////////////////
WORLD *world;
MODEL_3D *snowball, *snowmesh;
DATAFILE *data, *textures;
BITMAP *buffer, *snow_blast[4], *man_sprites[2];
JGMOD *music;
char *music_path;
player players[60];
snowfight_state game_state;
int color_depth = 16, viewport_w = 640, viewport_h = 480, fpscounter, a_fps,
    disp_fps, num_music_channels = 8, NUM_PLAYERS = 5;
volatile int fps;

//Flags//
char show_fps = FALSE, mute = FALSE, god_mode = FALSE;

//Functions//////////////////////////////////////////////////////////////////
void fps_proc()
{
  fps++;
} END_OF_FUNCTION(fps_proc);

int main(int argc, char *argv[])
{
  int i;
  for(i = 1; i < argc; i++)
  {
    if(stricmp(argv[i], "-mute") == 0) mute = TRUE;
    if(stricmp(argv[i], "-showfps") == 0) show_fps = TRUE;
  }

  snowfight_init();
  play_mod(music, TRUE);
  ls_logo();
  snowfight_loop();
  snowfight_shutdown();
  return 0;
}

void snowfight_init()
{
  RGB blue = { 0, 0, 50 };
  RGB black = { 0, 0, 0 };
  int card, i;

  allegro_init();
  set_config_file("config.cfg");
  music_path = get_config_string(NULL, "SongPath", "one.xm");

  install_keyboard();
  install_timer();
  install_mouse();
  set_gfx_mode(GFX_VGA, 320, 200, 0, 0);
  set_color(0, &black);
  set_color(255, &blue);

  if(!gfx_mode_select_ex(&card, &viewport_w, &viewport_h, &color_depth))
  {
		allegro_exit();
    exit(0);
  }
  set_color_depth(color_depth);
  if(set_gfx_mode(card, viewport_w, viewport_h, 0, 0) != 0)
  {
		set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
    cout << "Error setting gfx mode: " << allegro_error << "\n";
    allegro_exit();
    exit(1);
  }
  reserve_voices(16, -1);
  if(!mute)
  {
    if(install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL) != 0)
    {
      allegro_exit();
      printf("Sound init error: %s\n", allegro_error);
      exit(1);
    }
  }
  if(install_mod(num_music_channels) < 0)
  {
    allegro_exit();
    printf("Error setting digi voices");
    exit(1);
  }
  set_volume(-1, 255);
  set_mod_volume(128);
  data = load_datafile("snow.dat");
  if(!data) fatal_error("Error loading snow.dat!");
  textures = load_datafile("tex.dat");
  if(!textures) fatal_error("Error loading tex.dat!");
  music = load_mod(music_path);
  if(!music) fatal_error("Error loading specified song!!");
  buffer = create_bitmap(SCREEN_W, SCREEN_H);
  if(!buffer) fatal_error();
  LOCK_FUNCTION(fps_proc);
  LOCK_VARIABLE(fps);
  for(i = 0; i < 4; i++) snow_blast[i] = (BITMAP *) textures[3+i].dat;
  for(i = 0; i < 2; i++) man_sprites[i] = (BITMAP *) data[man_a+i].dat;

  text_mode(-1);

  //Setup variables
  srandom(time(0));
  game_state = state_title;
  for(i = 0; i < NUM_SNOWFLAKES; i++)
    snowflakes[i].init();
  install_int_ex(fps_proc, BPS_TO_TIMER(GAME_SPEED));
}

void snowfight_shutdown()
{
  set_config_string("Misc", "SongPath", music_path);
  unload_datafile(data);
  unload_datafile(textures);
  destroy_bitmap(buffer);
  destroy_mod(music);
  allegro_exit();
}

void ls_logo()
{
  DATAFILE *d;
  unsigned short pos = 0, i;

  d = load_datafile("lgmovie.dat");
  if(!d)
  {
    set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
    cout << "Error reading lgmovie.dat!!\n";
    allegro_exit();
    exit(1);
  }

  fps = fpscounter = 0;

  while(pos < 273)
  {
    fpscounter++;
    if(fpscounter % 12 == 0)
    {
      if(fpscounter >= fps)
      {
        if(pos < 18)
        {
          if(SCREEN_W != 320 && SCREEN_H != 240) stretch_blit((BITMAP *)d[(pos < 11) ? pos : pos-11].dat, screen, 0, 0, 320, 240, 0, 0, SCREEN_W, SCREEN_H);
          else blit((BITMAP *)d[(pos < 11) ? pos : pos-11].dat, screen, 0, 0, 0, 0, 320, 240);
        }
        else textout(screen, font, "__Kain__ (Mike Farrell)", SCREEN_W-184, SCREEN_H-8, makecol(pos-18, 0, 0));
      }
      if(pos < 18) pos++;
      else pos += 5;
    }
    while(fpscounter > fps) {}
  }
  drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
  blit(screen, buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
  set_trans_blender(0, 0, 0, 75);
  for(i = 0; i < 20; i++)
  {
	  rectfill(buffer, 0, 0, SCREEN_W, SCREEN_H, 0);
    blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
  }
  solid_mode();

  unload_datafile(d);
}

void fatal_error(char *msg)
{
  allegro_exit();
  printf("%s\n", msg);
  exit(1);
}
