/*=============================================================================
Proyecto: DADOO
< main.c >
23/Marzo/2002
=============================================================================*/

//===== Directivas
#include <allegro.h>
#include <stdio.h>
#include <conio.h>
#include "const.h"
#include "dado.h"
#include "mapa.h"
#include "archivos.h"
#include "fuentes.h"
#include "editor.h"
#include "jugar.h"

//===== Variables
DATAFILE *fuentes;
DATAFILE *img_cara;
int modo_grafico = GFX_AUTODETECT_WINDOWED;
int sin_sonido = 0;

//===== Funciones
int inicializar(void);
void mostrar_titulo(int cx, int cy);
int dibujar_fondo(char *img);
int menu_principal(int cx, int cy, int num_opc, char *opcs[]);
void mostrar_creditos(int cx, int cy);
int pantalla_completa(void);

/*----- main -----*/
int main(int argc, char *argv[]) {
  BITMAP *bmp;
  int x, y, i;
  int opc;
  char *opcs[] = {"Iniciar mapa", "Editar mapa", "Cambiar dado",
    "Pantalla completa", "Crditos"};

  // Inicializa el sistema
  if (inicializar()) return 1;

  // Carga las imgenes del dado
  img_cara = load_datafile(A_IMG_DADO_A);
  if (!img_cara) {
    alert("No se pudo abrir el archivo", A_IMG_DADO_A, NULL,
      "Ni modo", NULL, 'n', 0);
    return 1;
  }

  // Dibuja el ttulo y el fondo
  dibujar_fondo(A_FONDO);
  mostrar_titulo(5, 5);

  // Ejecuta el men principal
  while ((opc = menu_principal(200, 200, 5, opcs))) {
    switch (opc) {
    case 1:
      iniciar_mapa(NULL);
      break;
    case 2:
      editar_mapa();
      break;
    case 3:
      cambiar_dado();
      break;
    case 4:
      pantalla_completa();
      break;
    case 5:
      mostrar_creditos(0, 0);
      break;
    }
  }

  // Saliendo del programa
  bmp = create_bitmap(SCREEN_W, SCREEN_H);
  blit(screen, bmp, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
  i = 0;
  while (!key[KEY_ESC]) {
    x = SCREEN_W * (1 - (i/400.0));
    y = SCREEN_H * (1 - (i/400.0));
    if (x <= 0 || y <= 0) break;
    stretch_sprite(screen, bmp, (SCREEN_W-x)/2, (SCREEN_H-y)/2, x, y);
    rest(15);
    i++;
  }

  destroy_bitmap(bmp);
  unload_datafile(img_cara);
  allegro_exit();
  return 0;
}
END_OF_MAIN();

/*----- inicializar -----*/
int inicializar(void) {
  // Inicializacin de Allegro
  allegro_init();
  install_keyboard();
  install_timer();
  set_uformat(U_ASCII);
  set_window_title(PRY_VER);
  set_keyboard_rate(0, 0);
  //text_mode(-1);

  // Inicializa el sonido
  if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL)) {
    allegro_message("No pudo inicializarse el sonido.");
    //return 2;
    sin_sonido = 1;
  }
  else sin_sonido = 0;

  // Inicializa la parte grfica
  set_color_depth(16);
  if (set_gfx_mode(modo_grafico, 640, 480, 0, 0)) {
    allegro_message("No pudo ser inicializado el modo grfico:"
      " 640 x 480 x 16, a pantalla completa.");
    return 1;
  }

  // Carga las fuentes
  fuentes = load_datafile(A_FUENTES);
  if (!fuentes) return 3;

  return 0;
}

/*----- mostrar_titulo -----*/
void mostrar_titulo(int cx, int cy) {
  FONT *fuente1, *fuente2;
  int alto;

  // Elige las fuentes
  fuente1 = fuentes[F_MICRO_26].dat;
  fuente2 = fuentes[F_MICRO_18].dat;

  textprintf_ex(screen, fuente1, cx+5, cy+5, makecol16(0, 0, 0), -1,
    "DADOO, versin 0.41");
  textprintf_ex(screen, fuente1, cx, cy, makecol16(255, 255, 255), -1,
    "DADOO, versin 0.41");
  alto = text_height(fuente1);
  textprintf_ex(screen, fuente2, cx+5, cy+alto+5, makecol16(0, 0, 0), -1,
    "<< 27 de septiembre de 2002 >>");
  textprintf_ex(screen, fuente2, cx, cy+alto, makecol16(255, 255, 255), -1,
    "<< 27 de septiembre de 2002 >>");

  return;
}

/*----- dibujar_fondo -----*/
int dibujar_fondo(char *img) {
  BITMAP *fondo, *bmp;
  int x, y;

  fondo = create_bitmap(SCREEN_W, SCREEN_H);
  bmp = load_bitmap(img, NULL);
  if (!bmp) return 1;

  for (y = 0; y < SCREEN_H; y += 240) {
    for (x = 0; x < SCREEN_W; x += 320) {
      blit(bmp, fondo, 0, 0, x, y, 320, 240);
    }
  }
  blit(fondo, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

  destroy_bitmap(fondo);
  destroy_bitmap(bmp);

  return 0;
}

/*----- menu_principal -----*/
int menu_principal(int cx, int cy, int n_opcs, char *opcs[]) {
  BITMAP *marco, *fondo;
  FONT *fuente;
  int i, ant, alto, tecla = KEY_ENTER;
  int csel = makecol16(255, 200, 0);
  int nsel = makecol16(255, 255, 255);

  // Prepara el marco del men
  marco = create_bitmap(230, 200);
  fondo = create_bitmap(230, 200);
  blit(screen, marco, cx, cy, 0, 0, 230, 200);
  blit(screen, fondo, cx, cy, 0, 0, 230, 200);

  // Configura el tipo de transparencia
  set_trans_blender(0, 0, 0, 192);
  drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
  rectfill(marco, 0, 0, 229, 199, makecol16(127, 75, 127));
  solid_mode();
  rect(marco, 0, 0, 229, 199, makecol16(255, 255, 255));
  blit(marco, screen, 0, 0, cx, cy, 230, 200);

  // Muestra el men
  fuente = fuentes[F_ARBLK_16].dat;
  alto = text_height(fuente);
  for (i = 0; i < n_opcs; i++) {
    textout_ex(screen, fuente, opcs[i], cx+5, alto*i+cy+5, nsel, -1);
  }
  textout_ex(screen, fuente, "Salir", cx+5, alto*i+cy+5, nsel, -1);

  // Permite seleccionar una opcin
  clear_keybuf();
  i = ant = 0;

  while (tecla != KEY_ESC) {
    // Actualiza visualizacin
    if (i < n_opcs)
      textout_ex(screen, fuente, opcs[i], cx+5, alto*i+cy+5, csel, -1);
    else textout_ex(screen, fuente, "Salir", cx+5, alto*i+cy+5, csel, -1);

    // Permite seleccin
    ant = i;
    tecla = readkey() >> 8;

    // Evala seleccin
    switch (tecla) {
    case KEY_ESC:
      i = 0;
      break;
    case KEY_UP:
      if (i > 0) i--; else i = n_opcs;
      break;
    case KEY_DOWN:
      if (i < n_opcs) i++; else i = 0;
      break;
    case KEY_ENTER:
      if (i >= n_opcs) {
        i = 0;
        tecla = KEY_ESC;
      }
      else {
        i++;
        tecla = KEY_ESC;
      }
      break;
    }

    // Borra entrada anterior
    if (ant < n_opcs)
      textout_ex(screen, fuente, opcs[ant], cx+5, alto*ant+cy+5, nsel, -1);
    else textout_ex(screen, fuente, "Salir", cx+5, alto*ant+cy+5, nsel, -1);
  }

  blit(fondo, screen, 0, 0, cx, cy, 230, 200);
  destroy_bitmap(marco);
  destroy_bitmap(fondo);

  textprintf_ex(screen, font, 5, 15*BLQ, makecol16(255, 255, 255), -1,
    "i=%d", i);

  return i;
}

/*----- mostrar_creditos -----*/
void mostrar_creditos(int cx, int cy) {
  BITMAP *bmp;
  bmp = create_bitmap(SCREEN_W, SCREEN_H);
  blit(screen, bmp, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
  textout_ex(screen, fuentes[F_ARBLK_16].dat, "Todo yo, todo yo...",
    100, 150, makecol(255, 255, 255), -1);
  textout_ex(screen, fuentes[F_ARBLK_16].dat, "David Ros",
    100, 180, makecol(255, 255, 0), -1);
  readkey();
  blit(bmp, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
  destroy_bitmap(bmp);
  return;
}

int pantalla_completa(void) {
  BITMAP *bmp;

  // Guarda la pantalla
  bmp = create_bitmap(SCREEN_W, SCREEN_H);
  blit(screen, bmp, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

  // Cambia el modo grfico
  modo_grafico = modo_grafico == GFX_AUTODETECT_FULLSCREEN ?
    GFX_AUTODETECT_WINDOWED : GFX_AUTODETECT_FULLSCREEN;
  if (set_gfx_mode(modo_grafico, 640, 480, 0, 0)) {
    allegro_message("No pudo ser inicializado el modo grfico.");
    modo_grafico = modo_grafico == GFX_AUTODETECT_FULLSCREEN ?
      GFX_AUTODETECT_WINDOWED : GFX_AUTODETECT_FULLSCREEN;
    return 1;
  }

  // Restablece la pantalla
  blit(bmp, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
  destroy_bitmap(bmp);

  return 0;
}
