/*=============================================================================
Proyecto: DADOO
< dado.h >
25/Marzo/2002
=============================================================================*/

#ifndef DADO_H
  #define DADO_H

  //===== Constantes
  #define DA_NIN                 0
  #define DA_FLZ                 1
  #define DA_INI                 2
  #define DA_FIN                 3
  #define DA_IZQ                 11
  #define DA_DER                 12
  #define DA_ARR                 13
  #define DA_ABJ                 14
  #define DA_GIZ                 21
  #define DA_GDE                 22

  //===== Estructuras
  // Dado
  typedef struct {
    int caras[6];                // Distribucin de las caras
    int posX, posY;              // Posicin
    int anim;                    // ndice de animacin
    int accn;                    // Tipo de animacin
    int giro;                    // Puede girar?
  } DADO;

  //===== Funciones
  void preparar_dado(DADO *dado);
  void mover_dado(DADO *dado, int dir, int veces);
  void ajustar_dado(DADO *dado, int cara);
  int cambiar_dado(void);

#endif
