/*=============================================================================
Proyecto: DADOO
< dado.c >
25/Marzo/2002
=============================================================================*/

//===== Directivas
#include <allegro.h>
#include <stdio.h>
#include <conio.h>
#include "const.h"
#include "dado.h"
#include "fuentes.h"

//===== Variables
extern DATAFILE *img_cara;
extern DATAFILE *fuentes;

/*----- preparar_dado -----*/
void preparar_dado(DADO *dado) {
  dado->caras[C_SUP] = 1;      // Superior
  dado->caras[C_POS] = 6;      // Posterior
  dado->caras[C_IZQ] = 3;      // Izquierda
  dado->caras[C_DER] = 4;      // Derecha
  dado->caras[C_ARR] = 2;      // Arriba
  dado->caras[C_ABJ] = 5;      // Abajo
  return;
}

/*----- mover_dado -----*/
void mover_dado(DADO *dado, int dir, int veces) {
  int i, cc;

  for (i = 0; i < veces; i++) {
    switch (dir) {
    case DIR_IZQ:
      cc = dado->caras[C_SUP];
      dado->caras[C_SUP] = dado->caras[C_DER];
      dado->caras[C_DER] = dado->caras[C_POS];
      dado->caras[C_POS] = dado->caras[C_IZQ];
      dado->caras[C_IZQ] = cc;
      break;
    case DIR_DER:
      cc = dado->caras[C_SUP];
      dado->caras[C_SUP] = dado->caras[C_IZQ];
      dado->caras[C_IZQ] = dado->caras[C_POS];
      dado->caras[C_POS] = dado->caras[C_DER];
      dado->caras[C_DER] = cc;
      break;
    case DIR_ARR:
      cc = dado->caras[C_SUP];
      dado->caras[C_SUP] = dado->caras[C_ABJ];
      dado->caras[C_ABJ] = dado->caras[C_POS];
      dado->caras[C_POS] = dado->caras[C_ARR];
      dado->caras[C_ARR] = cc;
      break;
    case DIR_ABJ:
      cc = dado->caras[C_SUP];
      dado->caras[C_SUP] = dado->caras[C_ARR];
      dado->caras[C_ARR] = dado->caras[C_POS];
      dado->caras[C_POS] = dado->caras[C_ABJ];
      dado->caras[C_ABJ] = cc;
      break;
    case GIR_IZQ:
      cc = dado->caras[C_ARR];
      dado->caras[C_ARR] = dado->caras[C_DER];
      dado->caras[C_DER] = dado->caras[C_ABJ];
      dado->caras[C_ABJ] = dado->caras[C_IZQ];
      dado->caras[C_IZQ] = cc;
      break;
    case GIR_DER:
      cc = dado->caras[C_ARR];
      dado->caras[C_ARR] = dado->caras[C_IZQ];
      dado->caras[C_IZQ] = dado->caras[C_ABJ];
      dado->caras[C_ABJ] = dado->caras[C_DER];
      dado->caras[C_DER] = cc;
    }
  }
  return;
}

/*----- ajustar_dado -----*/
void ajustar_dado(DADO *dado, int cara) {
  int i;

  // Busca la cara en cuestin
  for (i = 0; i < 6; i++) {
    if (dado->caras[i] == cara) break;
  }

  // Ajusta la posicin del dado
  switch (i) {
  case C_POS:
    mover_dado(dado, DIR_ARR, 2);
    break;
  case C_IZQ:
    mover_dado(dado, DIR_DER, 1);
    break;
  case C_DER:
    mover_dado(dado, DIR_IZQ, 1);
    break;
  case C_ARR:
    mover_dado(dado, DIR_ABJ, 1);
    break;
  case C_ABJ:
    mover_dado(dado, DIR_ARR, 1);
    break;
  }
  return;
}

/*----- cambiar_dado -----*/
int cambiar_dado(void) {
  BITMAP *bmp, *fondo, *zona;
  DATAFILE *previo = NULL;
  int i, n = 0;
  int tecla;

  // Prepara bitmap y fondo
  fondo = create_bitmap(400, 300);
  bmp = create_bitmap(400, 300);
  zona = create_bitmap(5*BLQ, 5*BLQ);
  blit(screen, fondo, 40, 90, 0, 0, 400, 300);
  blit(screen, bmp, 40, 90, 0, 0, 400, 300);

  // Prepara el marco
  set_trans_blender(0, 0, 0, 127);
  drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
  rectfill(bmp, 0, 0, 399, 299, makecol16(0, 0, 0));
  solid_mode();
  rect(bmp, 0, 0, 399, 299, makecol16(0, 0, 0));
  blit(bmp, zona, 200, 100, 0, 0, 5*BLQ, 5*BLQ);
  blit(bmp, screen, 0, 0, 40, 90, 400, 300);

  clear_keybuf();
  do {
    // Elige el dado
    switch (n) {
    case 0:
      previo = load_datafile(A_IMG_DADO_A);
      break;
    case 1:
      previo = load_datafile(A_IMG_DADO_B);
      break;
    case 2:
      previo = load_datafile(A_IMG_DADO_C);
      break;
    case 3:
      previo = load_datafile(A_IMG_DADO_D);
      break;
    }
    // No se pudo cargar el archivo
    if (!previo) {
      n = MAX_NUM_DADOS;
      break;
    }

    // Muestra algo de informacin
    textout_ex(bmp, fuentes[F_ARBLK_16].dat, "Cambiar dado...",
      8, 8, makecol16(255, 255, 0), -1);
    textout_ex(bmp, fuentes[F_ARUNI_B12].dat, "[<-] Anterior",
      16, 100, makecol16(255, 255, 255), -1);
    textout_ex(bmp, fuentes[F_ARUNI_B12].dat, "[->] Siguiente",
      16, 150, makecol16(255, 255, 255), -1);
    textout_ex(bmp, fuentes[F_ARUNI_B12].dat, "[ENTER] Elegir",
      16, 200, makecol16(255, 255, 255), -1);
    textout_ex(bmp, fuentes[F_ARUNI_B12].dat, "[ESC] Cancelar",
      16, 250, makecol16(255, 255, 255), -1);

    // Muestra las caras del dado
    for (i = 0; i < 32; i++) {
      set_trans_blender(0, 0, 0, 8*(i+1));
      blit(zona, bmp, 0, 0, 200, 100, 5*BLQ, 5*BLQ);

      draw_trans_sprite(bmp, previo[0].dat, 200+2*BLQ, 100);
      draw_trans_sprite(bmp, previo[1].dat, 200, 100+BLQ);
      draw_trans_sprite(bmp, previo[2].dat, 200+2*BLQ, 100+2*BLQ);
      draw_trans_sprite(bmp, previo[3].dat, 200+4*BLQ, 100+1*BLQ);
      draw_trans_sprite(bmp, previo[4].dat, 200, 100+3*BLQ);
      draw_trans_sprite(bmp, previo[5].dat, 200+2*BLQ, 100+4*BLQ);
      draw_trans_sprite(bmp, previo[6].dat, 200+4*BLQ, 100+3*BLQ);

      rest(25);
      blit(bmp, screen, 0, 0, 40, 90, 400, 300);
    }

    // Recibe nueva tecla
    clear_keybuf();
    tecla = readkey() >> 8;
    switch (tecla) {
    case KEY_LEFT:
      if (n > 0) n--; else n = MAX_NUM_DADOS - 1;
      break;
    case KEY_RIGHT:
      if (n < MAX_NUM_DADOS - 1) n++; else n = 0;
      break;
    case KEY_ESC:
      n = MAX_NUM_DADOS;
      break;
    case KEY_ENTER:
      tecla = KEY_ESC;
      break;
    }

    unload_datafile(previo);
  } while (tecla != KEY_ESC);

  // Carga el nuevo dado
  if (n >= 0 && n < MAX_NUM_DADOS) {
    unload_datafile(img_cara);
    switch (n) {
    case 0:
      img_cara = load_datafile(A_IMG_DADO_A);
      break;
    case 1:
      img_cara = load_datafile(A_IMG_DADO_B);
      break;
    case 2:
      img_cara = load_datafile(A_IMG_DADO_C);
      break;
    case 3:
      img_cara = load_datafile(A_IMG_DADO_D);
      break;
    }
  }

  blit(fondo, screen, 0, 0, 40, 90, 400, 300);
  destroy_bitmap(bmp);
  destroy_bitmap(fondo);
  destroy_bitmap(zona);
  if (!img_cara) return 1;

  return 0;
}
