/*=============================================================================
Proyecto: DADOO
< mapa.h >
25/Marzo/2002
=============================================================================*/

#ifndef MAPA_H
  #define MAPA_H

  //===== Directivas
  #include "dado.h"
  
  //===== Estructuras
  // Mapa de laberinto
  typedef struct {
    int dimX, dimY;              // Dimensiones
    int iniX, iniY;              // Posicin inicial
    int finX, finY;              // Posicin final
    int esp[MAX_Y][MAX_X];       // Espacios
  } MAPA;

  //===== Funciones
  void dibujar_mapa(BITMAP *bmp, MAPA *mapa);
  void dibujar_espacio(BITMAP *bmp, int posX, int posY,
    MAPA *mapa, int cx, int cy);
  void dibujar_cursor(BITMAP *bmp, int cx, int cy);
  void dibujar_panel_edicion(BITMAP *bmp, DADO *dado, MAPA *mapa, char *nom);
  void vaciar_mapa(MAPA *mapa);

#endif
