/*=============================================================================
Proyecto: DADOO
< mapa.c >
25/Marzo/2002
=============================================================================*/

//===== Directivas
#include <allegro.h>
#include <stdio.h>
#include <conio.h>
#include "const.h"
#include "mapa.h"
#include "fuentes.h"

//===== Variables
extern DATAFILE *img_cara;
extern DATAFILE *fuentes;

/*----- dibujar_mapa -----*/
void dibujar_mapa(BITMAP *bmp, MAPA *mapa) {
  int i, j, cc;

  // Dibuja el contenido del mapa
  for (j = 0; j < mapa->dimY; j++) {
    for (i = 0; i < mapa->dimX; i++) {
      cc = mapa->esp[j][i];
      if (cc < 1 || cc > 6) cc = 0;
      blit(img_cara[cc].dat, bmp, 0, 0, i*BLQ, j*BLQ, BLQ, BLQ);
    }
  }
  return;
}

/*----- dibujar_espacio -----*/
void dibujar_espacio(BITMAP *bmp, int posX, int posY,
  MAPA *mapa, int cx, int cy) {
  int cc;

  cc = mapa->esp[cy][cx];
  if (cc < 1 || cc > 6) cc = 0;
  blit(img_cara[cc].dat, bmp, 0, 0, posX, posY, BLQ, BLQ);
  return;
}

/*----- dibujar_cursor -----*/
void dibujar_cursor(BITMAP *bmp, int cx, int cy) {
  rect(bmp, cx, cy, cx+BLQ-1, cy+BLQ-1, makecol16(0, 255, 0));
  return;
}

/*----- dibujar_panel_edicion -----*/
void dibujar_panel_edicion(BITMAP *bmp, DADO *dado, MAPA *mapa, char *nom) {
  BITMAP *fondo;
  FONT *fuente;
  int i, j, val;

  // Dibuja el fondo
  fondo = load_bitmap(A_FONDO, NULL);
  if (fondo) {
    for (j = 0; j < SCREEN_H; j += 240) {
      for (i = 0; i < 5*BLQ; i += 320) {
        blit(fondo, bmp, 0, 0, i, j, 320, 240);
      }
    }
    destroy_bitmap(fondo);
  }
  else clear_bitmap(bmp);

  // Algunos datos...
  fuente = fuentes[F_ARUNI_B12].dat;
  i = dado->posX;
  j = dado->posY;
  val = mapa->esp[j][i];

  // Cara superior
  if (val >= 1 && val <= 6)
    blit(img_cara[dado->caras[C_SUP]].dat, bmp, 0, 0, 2*BLQ, 3*BLQ, BLQ, BLQ);
  else blit(img_cara[0].dat, bmp, 0, 0, 2*BLQ, 3*BLQ, BLQ, BLQ);

  // Resto de las caras
  blit(img_cara[dado->caras[C_IZQ]].dat, bmp, 0, 0, BLQ, 3*BLQ, BLQ, BLQ);
  blit(img_cara[dado->caras[C_DER]].dat, bmp, 0, 0, 3*BLQ, 3*BLQ, BLQ, BLQ);
  blit(img_cara[dado->caras[C_ARR]].dat, bmp, 0, 0, 2*BLQ, 2*BLQ, BLQ, BLQ);
  blit(img_cara[dado->caras[C_ABJ]].dat, bmp, 0, 0, 2*BLQ, 4*BLQ, BLQ, BLQ);

  // Muestra informacin
  textprintf_ex(bmp, fuente, 8, 8, makecol16(255, 255, 255), -1,
    "<%s>", nom);
  textprintf_ex(bmp, fuente, 8, 6*BLQ, makecol16(255, 255, 0), -1,
    "Cursor:");
  textprintf_ex(bmp, fuente, 8, 7*BLQ, makecol16(255, 255, 255), -1,
    "[x=%2d, y=%2d]", i, j);
  textprintf_ex(bmp, fuente, 8, 8*BLQ, makecol16(255, 255, 0), -1,
    "Casilla:");
  textprintf_ex(bmp, fuente, 8, 9*BLQ, makecol16(255, 255, 255), -1,
    "[%2d]", mapa->esp[j][i]);
  textprintf_ex(bmp, fuente, 8, 10*BLQ, makecol16(255, 255, 0), -1,
    "Inicio:");
  textprintf_ex(bmp, fuente, 8, 11*BLQ, makecol16(255, 255, 255), -1,
    "[x=%2d, y=%2d]", mapa->iniX, mapa->iniY);
  textprintf_ex(bmp, fuente, 8, 12*BLQ, makecol16(255, 255, 0), -1,
    "Final:");
  textprintf_ex(bmp, fuente, 8, 13*BLQ, makecol16(255, 255, 255), -1,
    "[x=%2d, y=%2d]", mapa->finX, mapa->finY);

  return;
}

/*----- vaciar_mapa -----*/
void vaciar_mapa(MAPA *mapa) {
  int i, j;

  mapa->dimX = MAX_X;
  mapa->dimY = MAX_Y;
  mapa->iniX = mapa->iniY = 0;
  mapa->finX = MAX_X - 1;
  mapa->finY = MAX_Y - 1;
  for (j = 0; j < MAX_Y; j++) {
    for (i = 0; i < MAX_X; i++) mapa->esp[j][i] = 0;
  }

  return;
}
