/*=============================================================================
Proyecto: DADOO
< jugar.h >
25/Marzo/2002
=============================================================================*/

#ifndef JUGAR_H
  #define JUGAR_H

  //===== Directivas
  #include "dado.h"
  #include "mapa.h"

  //===== Constantes
  #define MAX_TECLAS             12
  #define TECLAS_RET             12
  #define T_TOT                  0
  #define T_ESC                  1
  #define T_IZQ                  2
  #define T_DER                  3
  #define T_ARR                  4
  #define T_ABJ                  5
  #define T_ENT                  6
  #define T_REP                  7
  #define T_AVP                  8
  #define T_F5                   9
  #define T_F6                   10
  #define T_F7                   11

  #define MAX_DADO_ANIM          8

  //===== Estructuras
  // Controlador de 'retardo' del teclado
  typedef struct {
    int act[MAX_TECLAS];         // Actividad de la tecla
    int ret[MAX_TECLAS];         // Tiempo de retardo
  } TECLAS;

  //===== Funciones
  void reloj(void);
  void iniciar_mapa(char *nomarg);
  int dibujar_dado(BITMAP *bmp, DADO *dado, MAPA *mapa);
  void dibujar_marcas(BITMAP *bmp, MAPA *mapa, int *ini_anim, int *fin_anim);
  void dibujar_alrededor(BITMAP *bmp, DADO *dado, MAPA *mapa);
  void efc_sonido(int sonido);
  void mapa_terminado(void);
  void dibujar_panel_juego(BITMAP *bmp, DADO *dado, MAPA *mapa);
  void mostrar_ayuda(void);

#endif
