/*=============================================================================
Proyecto: DADOO
< jugar.c >
25/Marzo/2002
=============================================================================*/

//===== Directivas
#include <allegro.h>
#include <stdio.h>
#include <conio.h>
#include "const.h"
#include "jugar.h"
#include "archivos.h"
#include "sonidos.h"
#include "imagen.h"
#include "fuentes.h"

//===== Variables
extern DATAFILE *fuentes;
extern DATAFILE *img_cara;
extern int sin_sonido;
DATAFILE *imagen;
DATAFILE *sonidos;
BITMAP *auxbmp;
BITMAP *fondo, *fondo_B;
BITMAP *bmp_cps;
volatile int r_activo = 0;
volatile int r_cps = 0;
volatile TECLAS tt;
int movs = 0;
int mostrar_cps = 1;
int indicadores = 1;

/*----- reloj -----*/
void reloj(void) {
  int i;

  // Permite la ejecucin de nuevos ciclos
  r_activo = 1;

  // Procesa retardos
  for (i = 1; i < MAX_TECLAS; i++) {
    if (tt.ret[i] > 0) tt.ret[i]--;
    else tt.act[i] = 1;
  }

  return;
}
END_OF_FUNCTION(reloj);

/*----- reloj_cps -----*/
void reloj_cps(void) {
  if (mostrar_cps) {
    //text_mode(0);
    textprintf_ex(bmp_cps, font, 8, 14*BLQ, makecol16(255, 255, 255), 0,
      "CPS: %3d/48", r_cps);
    //text_mode(-1);
  }
  r_cps = 0;
  return;
}
END_OF_FUNCTION(reloj_cps);

/*----- iniciar_mapa -----*/
void iniciar_mapa(char *nomarg) {
  BITMAP *panA, *panB;
  MAPA mapa;
  DADO dado;
  int i, j, ax = 0, ay = 0;
  //int tecla = KEY_ENTER;
  int resp;
  int ini_anim = 0, fin_anim = 0;
  char nombre[512] = ".";

  // Creacin de los paneles o pantallas
  panA = create_bitmap(MAX_X * BLQ, MAX_Y * BLQ);
  clear_bitmap(panA);
  panB = create_bitmap(5 * BLQ, MAX_Y * BLQ);
  clear_bitmap(panB);
  fondo_B = create_bitmap(5 * BLQ, MAX_Y * BLQ);
  clear_bitmap(fondo_B);
  auxbmp = create_bitmap(BLQ, BLQ);
  bmp_cps = panA;

  // Carga las imgenes
  imagen = load_datafile(A_IMAGEN);
  if (!imagen) {
    alert("No se pudo abrir el archivo", A_IMAGEN, NULL,
      "Ni modo", NULL, 'n', 0);
    return;
  }

  // Prepara mapa y dado
  if ((resp = abrir_mapa(&mapa, nombre, 1))) {
    if (resp == 1) alert("No se encontr el archivo.", NULL, NULL,
      "Ni modo", NULL, 'n', 0);
    return;
  }
  dado.posX = mapa.iniX;
  dado.posY = mapa.iniY;
  dado.giro = 1;
  preparar_dado(&dado);
  ajustar_dado(&dado, mapa.esp[dado.posY][dado.posX]);

  // Prepara el fondo del panel B
  fondo = load_bitmap(A_FONDO, NULL);
  if (fondo) {
    for (j = 0; j < SCREEN_H; j += 240) {
      for (i = 0; i < 5*BLQ; i += 320) {
        blit(fondo, fondo_B, 0, 0, i, j, 320, 240);
      }
    }
    destroy_bitmap(fondo);
  }
  textprintf_ex(fondo_B, fuentes[F_ARUNI_B12].dat, 8, 8,
    makecol16(255, 255, 255), -1, "<%s>", nombre);

  // Carga los sonidos
  sonidos = load_datafile(A_SONIDO);
  if (!sonidos) {
    alert("No se pudieron cargar los sonidos.", NULL, NULL,
      "Ni modo", NULL, 'n', 0);
    return;
  }

  // Inicializa la estructura de teclas
  for (i = 0; i < MAX_TECLAS; i++) {
    tt.act[i] = 1;
    tt.ret[i] = 0;
  }

  // Inicializa el temporizador
  LOCK_FUNCTION(reloj);
  LOCK_FUNCTION(reloj_cps);
  LOCK_VARIABLE(r_activo);
  LOCK_VARIABLE(r_cps);
  install_int_ex(reloj, BPS_TO_TIMER(48));
  install_int_ex(reloj_cps, BPS_TO_TIMER(1));

  // Actualizacin de la pantalla
  clear_bitmap(screen);
  dibujar_mapa(panA, &mapa);
  blit(panA, screen, 0, 0, 0, 0, MAX_X*BLQ, MAX_Y*BLQ);

  // Permite movimiento del dado
  i = dado.posX;
  j = dado.posY;
  dado.anim = 0;
  dado.accn = DA_INI;
  movs = 0;
  r_activo = 1;
  r_cps = 0;

  while (!key[KEY_ESC]) {
    // Tiempo de un nuevo ciclo
    if (!r_activo) continue;

    // Actualiza animacin
    dibujar_alrededor(panA, &dado, &mapa);
    dibujar_marcas(panA, &mapa, &ini_anim, &fin_anim);
    tt.act[T_TOT] = dibujar_dado(panA, &dado, &mapa);
    if (tt.act[T_TOT] == -1) break;
    else tt.act[T_TOT] = !tt.act[T_TOT];

    // Revisa posicin final
    if (dado.posX == mapa.finX && dado.posY == mapa.finY
      && dado.accn != DA_FIN) {
      tt.act[T_TOT] = 0;
      dado.anim = -1;
      dado.accn = DA_FIN;
    }

    // Actualiza la pantalla
    dibujar_panel_juego(panB, &dado, &mapa);
    blit(panA, screen, 0, 0, 0, 0, MAX_X*BLQ, MAX_Y*BLQ);
    blit(panB, screen, 0, 0, MAX_X*BLQ, 0, 5*BLQ, MAX_Y*BLQ);

    // Guarda posicin anterior
    ax = dado.posX;
    ay = dado.posY;

    // Procesa las teclas
    if (tt.act[T_TOT]) {
      // Mover izquierda
      if (key[KEY_LEFT] && tt.act[T_IZQ]) {
        if (dado.caras[C_DER] == mapa.esp[dado.posY][dado.posX-1]) {
          dado.anim = -1;
          dado.accn = DA_IZQ;
          dado.giro = 1;
          movs++;
        }
        else efc_sonido(S_NONO);
        tt.act[T_IZQ] = 0;
        tt.ret[T_IZQ] = TECLAS_RET;
      }
      // Mover derecha
      if (key[KEY_RIGHT] && tt.act[T_DER]) {
        if (dado.caras[C_IZQ] == mapa.esp[dado.posY][dado.posX+1]) {
          dado.anim = -1;
          dado.accn = DA_DER;
          dado.giro = 1;
          movs++;
        }
        else efc_sonido(S_NONO);
        tt.act[T_DER] = 0;
        tt.ret[T_DER] = TECLAS_RET;
      }
      // Mover arriba
      if (key[KEY_UP] && tt.act[T_ARR]) {
        if (dado.caras[C_ABJ] == mapa.esp[dado.posY-1][dado.posX]) {
          dado.anim = -1;
          dado.accn = DA_ARR;
          dado.giro = 1;
          movs++;
        }
        else efc_sonido(S_NONO);
        tt.act[T_ARR] = 0;
        tt.ret[T_ARR] = TECLAS_RET;
      }
      // Mover abajo
      if (key[KEY_DOWN] && tt.act[T_ABJ]) {
        if (dado.caras[C_ARR] == mapa.esp[dado.posY+1][dado.posX]) {
          dado.anim = -1;
          dado.accn = DA_ABJ;
          dado.giro = 1;
          movs++;
        }
        else efc_sonido(S_NONO);
        tt.act[T_ABJ] = 0;
        tt.ret[T_ABJ] = TECLAS_RET;
      }
      // Girar izquierda
      if (key[KEY_PGUP] && tt.act[T_REP] && dado.giro) {
        dado.anim = -1;
        dado.accn = DA_GIZ;
        dado.giro = 0;
        movs++;
        tt.act[T_REP] = 0;
        tt.ret[T_REP] = TECLAS_RET;
      }
      // Girar derecha
      if (key[KEY_PGDN] && tt.act[T_AVP] && dado.giro) {
        dado.anim = -1;
        dado.accn = DA_GDE;
        dado.giro = 0;
        movs++;
        tt.act[T_AVP] = 0;
        tt.ret[T_AVP] = TECLAS_RET;
      }
      // Mostrar ayuda
      if (key[KEY_F1]) {
        mostrar_ayuda();
      }
      // Mostrar/Ocultar cuadros por segundo (cps)
      if (key[KEY_F5] && tt.act[T_F5]) {
        mostrar_cps = !mostrar_cps;
        if (mostrar_cps) efc_sonido(S_MAPAFIN);
        else {
          efc_sonido(S_NONO);
          dibujar_mapa(panA, &mapa);
        }
        tt.act[T_F5] = 0;
        tt.ret[T_F5] = TECLAS_RET;
      }
      // Mostrar/Ocultar indicadores
      if (key[KEY_F6] && tt.act[T_F6]) {
        indicadores = !indicadores;
        if (indicadores) efc_sonido(S_MAPAFIN);
        else efc_sonido(S_NONO);
        tt.act[T_F6] = 0;
        tt.ret[T_F6] = TECLAS_RET;
      }
      // Permitir/Cancelar giro
      if (key[KEY_F7] && tt.act[T_F7]) {
        dado.giro = !dado.giro;
        if (dado.giro) efc_sonido(S_MAPAFIN);
        else efc_sonido(S_NONO);
        tt.act[T_F7] = 0;
        tt.ret[T_F7] = TECLAS_RET;
      }

    } // (Procesamiento de teclas)

    // Revisa ndices de animacin
    dado.anim++;
    ini_anim++;
    fin_anim++;
    r_activo = 0;
    r_cps++;
  }

  // El mapa fue terminado?
  if (tt.act[T_TOT] == -1) mapa_terminado();

  unload_datafile(imagen);
  unload_datafile(sonidos);
  destroy_bitmap(panA);
  destroy_bitmap(panB);
  destroy_bitmap(auxbmp);
  destroy_bitmap(fondo_B);
  remove_int(reloj);
  remove_int(reloj_cps);

  return;
}

/*----- dibujar_dado -----*/
int dibujar_dado(BITMAP *bmp, DADO *dado, MAPA *mapa) {
  int resp = 0;
  int x, y;

  switch (dado->accn) {
  // Dado 'feliz' listo para recibir mandatos
  case DA_FLZ:
    if (dado->anim >= 48) dado->anim = 0;

    if (indicadores) {
      // Determina posibles rutas
      clear_to_color(auxbmp, makecol16(255, 0, 0));
      y = dado->anim < 24 ? 48+4*dado->anim : 144-4*(dado->anim-24);
      set_trans_blender(0, 0, 0, y);
      if (dado->caras[C_DER] == mapa->esp[dado->posY][dado->posX-1])
        draw_trans_sprite(bmp, auxbmp, BLQ*(dado->posX-1), BLQ*dado->posY);
      if (dado->caras[C_IZQ] == mapa->esp[dado->posY][dado->posX+1])
        draw_trans_sprite(bmp, auxbmp, BLQ*(dado->posX+1), BLQ*dado->posY);
      if (dado->caras[C_ABJ] == mapa->esp[dado->posY-1][dado->posX])
        draw_trans_sprite(bmp, auxbmp, BLQ*dado->posX, BLQ*(dado->posY-1));
      if (dado->caras[C_ARR] == mapa->esp[dado->posY+1][dado->posX])
        draw_trans_sprite(bmp, auxbmp, BLQ*dado->posX, BLQ*(dado->posY+1));
    }

    // Calcula inclinacin
    if (dado->anim >= 0 && dado->anim < 12) x = itofix(dado->anim);
    else if (dado->anim >= 12 && dado->anim < 24) x = itofix(24-dado->anim);
    else if (dado->anim >= 24 && dado->anim < 36) x = itofix(280-dado->anim);
    else x = itofix(dado->anim+208);
    rotate_sprite(bmp, img_cara[dado->caras[C_SUP]].dat,
      dado->posX*BLQ, dado->posY*BLQ, x);
    break;

  // Dado haciendo aparicin inicial
  case DA_INI:
    if (dado->anim < 32) {
      if (dado->anim == 0) efc_sonido(S_MAPAINI);
      blit(img_cara[0].dat, bmp, 0, 0,
        BLQ*dado->posX, BLQ*dado->posY, BLQ, BLQ);
      if (dado->anim) {
        x = BLQ*dado->posX + (BLQ - dado->anim)/2;
        y = BLQ*dado->posY + (BLQ - dado->anim)/2;
        stretch_sprite(bmp, img_cara[dado->caras[C_SUP]].dat,
          x, y, dado->anim, dado->anim);
      }
      resp = 1;
    }
    else {
      // Da por terminada la animacin
      dado->anim = 0;
      dado->accn = DA_FLZ;
    }
    break;

  // Dado terminando el mapa
  case DA_FIN:
    if (dado->anim < 32) {
      if (dado->anim == 1) efc_sonido(S_MAPAFIN);
      // Calcula proporciones
      x = dado->anim < 16 ? BLQ + dado->anim : 2*BLQ - dado->anim;
      y = dado->anim < 16 ? (-dado->anim)/2 : (dado->anim - BLQ)/2;
      stretch_sprite(bmp, img_cara[dado->caras[C_SUP]].dat,
        BLQ*dado->posX+y, BLQ*dado->posY+y, x, x);
      resp = 1;
    }
    else {
      // Da por terminada la animacin
      dado->anim = 0;
      dado->accn = DA_FLZ;
      resp = -1;
    }
    break;

  // Dado movindose a la izquierda
  case DA_IZQ:
    if (dado->anim < 16) {
      if (dado->anim) {
        y = 12 * dado->anim;            // Cantidad de color
        x = 2 *dado->anim;              // Tamao
        set_trans_blender(0, 0, 0, 0);  // Sombra
        if (dado->anim == 12) efc_sonido(S_MOVER);

        clear_to_color(auxbmp, makecol16(255, 0, 255));
        stretch_sprite(auxbmp, img_cara[dado->caras[C_DER]].dat,
          BLQ-x, 0, x, BLQ);
        draw_lit_sprite(bmp, auxbmp,
          BLQ*dado->posX-x, BLQ*dado->posY, 192-y);

        clear_to_color(auxbmp, makecol16(255, 0, 255));
        stretch_sprite(auxbmp, img_cara[dado->caras[C_SUP]].dat,
          0, 0, BLQ-x, BLQ);
        draw_lit_sprite(bmp, auxbmp,
          BLQ*dado->posX-x, BLQ*dado->posY, y);
      }
      else blit(img_cara[dado->caras[C_SUP]].dat, bmp,
        0, 0, BLQ*dado->posX, BLQ*dado->posY, BLQ, BLQ);
      resp = 1;
    }
    else {
      // Da por terminada la animacin
      mover_dado(dado, DIR_IZQ, 1);
      dado->posX--;
      dado->anim = 0;
      dado->accn = DA_FLZ;
    }
    break;

  // Dado movindose a la derecha
  case DA_DER:
    if (dado->anim < 16) {
      if (dado->anim) {
        y = 12 * dado->anim;            // Cantidad de color
        x = 2 *dado->anim;              // Tamao
        set_trans_blender(0, 0, 0, 0);  // Sombra
        if (dado->anim == 12) efc_sonido(S_MOVER);

        clear_to_color(auxbmp, makecol16(255, 0, 255));
        stretch_sprite(auxbmp, img_cara[dado->caras[C_IZQ]].dat,
          0, 0, x, BLQ);
        draw_lit_sprite(bmp, auxbmp,
          BLQ*dado->posX+x, BLQ*dado->posY, 192-y);

        clear_to_color(auxbmp, makecol16(255, 0, 255));
        stretch_sprite(auxbmp, img_cara[dado->caras[C_SUP]].dat,
          x, 0, BLQ-x, BLQ);
        draw_lit_sprite(bmp, auxbmp,
          BLQ*dado->posX+x, BLQ*dado->posY, y);
      }
      else blit(img_cara[dado->caras[C_SUP]].dat, bmp,
        0, 0, BLQ*dado->posX, BLQ*dado->posY, BLQ, BLQ);
      resp = 1;
    }
    else {
      // Da por terminada la animacin
      mover_dado(dado, DIR_DER, 1);
      dado->posX++;
      dado->anim = 0;
      dado->accn = DA_FLZ;
    }
    break;

  // Dado movindose hacia arriba
  case DA_ARR:
    if (dado->anim < 16) {
      if (dado->anim) {
        y = 12 * dado->anim;            // Cantidad de color
        x = 2 *dado->anim;              // Tamao
        set_trans_blender(0, 0, 0, 0);  // Sombra
        if (dado->anim == 12) efc_sonido(S_MOVER);

        clear_to_color(auxbmp, makecol16(255, 0, 255));
        stretch_sprite(auxbmp, img_cara[dado->caras[C_ABJ]].dat,
          0, BLQ-x, BLQ, x);
        draw_lit_sprite(bmp, auxbmp,
          BLQ*dado->posX, BLQ*dado->posY-x, 192-y);

        clear_to_color(auxbmp, makecol16(255, 0, 255));
        stretch_sprite(auxbmp, img_cara[dado->caras[C_SUP]].dat,
          0, 0, BLQ, BLQ-x);
        draw_lit_sprite(bmp, auxbmp,
          BLQ*dado->posX, BLQ*dado->posY-x, y);
      }
      else blit(img_cara[dado->caras[C_SUP]].dat, bmp,
        0, 0, BLQ*dado->posX, BLQ*dado->posY, BLQ, BLQ);
      resp = 1;
    }
    else {
      // Da por terminada la animacin
      mover_dado(dado, DIR_ARR, 1);
      dado->posY--;
      dado->anim = 0;
      dado->accn = DA_FLZ;
    }
    break;

  // Dado movindose hacia abajo
  case DA_ABJ:
    if (dado->anim < 16) {
      if (dado->anim) {
        y = 12 * dado->anim;            // Cantidad de color
        x = 2 *dado->anim;              // Tamao
        set_trans_blender(0, 0, 0, 0);  // Sombra
        if (dado->anim == 12) efc_sonido(S_MOVER);

        clear_to_color(auxbmp, makecol16(255, 0, 255));
        stretch_sprite(auxbmp, img_cara[dado->caras[C_ARR]].dat,
          0, 0, BLQ, x);
        draw_lit_sprite(bmp, auxbmp,
          BLQ*dado->posX, BLQ*dado->posY+x, 192-y);

        clear_to_color(auxbmp, makecol16(255, 0, 255));
        stretch_sprite(auxbmp, img_cara[dado->caras[C_SUP]].dat,
          0, x, BLQ, BLQ-x);
        draw_lit_sprite(bmp, auxbmp,
          BLQ*dado->posX, BLQ*dado->posY+x, y);
      }
      else blit(img_cara[dado->caras[C_SUP]].dat, bmp,
        0, 0, BLQ*dado->posX, BLQ*dado->posY, BLQ, BLQ);
      resp = 1;
    }
    else {
      // Da por terminada la animacin
      mover_dado(dado, DIR_ABJ, 1);
      dado->posY++;
      dado->anim = 0;
      dado->accn = DA_FLZ;
    }
    break;

  // Dado girando hacia la izquierda
  case DA_GIZ:
    if (dado->anim < 32) {
      // Calcula el ngulo
      x = itofix(512 - 16 * dado->anim);
      if (dado->anim == 8 || dado->anim == 24) efc_sonido(S_GIRAR);
      rotate_sprite(bmp, img_cara[dado->caras[C_SUP]].dat,
        BLQ*dado->posX, BLQ*dado->posY, x);
      resp = 1;
    }
    else {
      // Da por terminada la animacin
      mover_dado(dado, GIR_IZQ, 1);
      dado->anim = 0;
      dado->accn = DA_FLZ;
    }
    break;

  // Dado girando hacia la derecha
  case DA_GDE:
    if (dado->anim < 32) {
      // Calcula el ngulo
      x = itofix(16 * dado->anim);
      if (dado->anim == 8 || dado->anim == 24) efc_sonido(S_GIRAR);
      rotate_sprite(bmp, img_cara[dado->caras[C_SUP]].dat,
        BLQ*dado->posX, BLQ*dado->posY, x);
      resp = 1;
    }
    else {
      // Da por terminada la animacin
      mover_dado(dado, GIR_DER, 1);
      dado->anim = 0;
      dado->accn = DA_FLZ;
    }
    break;

  } // ('switch' dado->accn)

  return resp;
}

/*----- dibujar_marcas -----*/
void dibujar_marcas(BITMAP *bmp, MAPA *mapa, int *ini_anim, int *fin_anim) {
  int alfa;

  // Marca inicial
  if (*ini_anim >= 96) *ini_anim = 0;
  alfa = *ini_anim < 48 ? 2*(*ini_anim)+32 : 128-(2*(*ini_anim-48));
  set_trans_blender(0, 0, 0, alfa);
  dibujar_espacio(bmp, BLQ*mapa->iniX, BLQ*mapa->iniY,
    mapa, mapa->iniX, mapa->iniY);
  draw_trans_sprite(bmp, imagen[IMG_POS_INI].dat,
    BLQ*mapa->iniX, BLQ*mapa->iniY);

  // Marca final
  if (*fin_anim >= 96) *fin_anim = 0;
  alfa = *ini_anim < 48 ? 2*(*ini_anim)+32 : 128-(2*(*ini_anim-48));
  set_trans_blender(0, 0, 0, alfa);
  dibujar_espacio(bmp, BLQ*mapa->finX, BLQ*mapa->finY,
    mapa, mapa->finX, mapa->finY);
  draw_trans_sprite(bmp, imagen[IMG_POS_FIN].dat,
    BLQ*mapa->finX, BLQ*mapa->finY);

  return;
}

/*----- dibujar_alrededor -----*/
void dibujar_alrededor(BITMAP *bmp, DADO *dado, MAPA *mapa) {
  int i, j;

  // Dibuja los espacios alrededor del dado
  for (j = dado->posY-1; j <= dado->posY+1; j++) {
    for (i = dado->posX-1; i <= dado->posX+1; i++) {
      if (i < 0 || i >= mapa->dimX) continue;
      if (j < 0 || j >= mapa->dimY) continue;
      dibujar_espacio(bmp, i*BLQ, j*BLQ, mapa, i, j);
    }
  }

  return;
}

/*----- efc_sonido -----*/
void efc_sonido(int sonido) {
  if (!sin_sonido)
    play_sample(sonidos[sonido].dat, 127, 127, 1000, 0);
  return;
}

/*----- mapa_terminado -----*/
void mapa_terminado(void) {
  BITMAP *bmp;
  int i, h, y;

  bmp = create_bitmap(BLQ*MAX_X, BLQ*MAX_Y);
  blit(screen, bmp, 0, 0, 0, 0, BLQ*MAX_X, BLQ*MAX_Y);
  set_trans_blender(0, 0, 0, 24);
  drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);

  for (i = 0; i < 20; i++) {
    y = BLQ*(MAX_Y/2);
    h = 8 * i;
    rectfill(bmp, 0, y-h, BLQ*MAX_X-1, y+h, makecol16(0, 0, 0));
    blit(bmp, screen, 0, 0, 0, 0, BLQ*MAX_X, BLQ*MAX_Y);
    rest(25);
  }

  solid_mode();
  textout_centre_ex(screen, fuentes[F_MICRO_26].dat, "Mapa finalizado!",
    BLQ*(MAX_X/2), BLQ*(MAX_Y/2-1), makecol16(255, 255, 255), -1);
  textprintf_centre_ex(screen, fuentes[F_MICRO_18].dat,
    BLQ*(MAX_X/2), BLQ*(MAX_Y/2+1), makecol16(255, 255, 255), -1,
    "Movimientos: %d", movs);
  while (!key[KEY_ENTER]);

  return;
}

/*----- dibujar_panel_juego -----*/
void dibujar_panel_juego(BITMAP *bmp, DADO *dado, MAPA *mapa) {
  int x = 0, y = 0;
  char cad[5];

  // Los lmites de 'dado.anim' son controlados desde 'dibujar_dado'

  // Restablece el fondo
  blit(fondo_B, bmp, 0, 0, 0, 0, 5*BLQ, MAX_Y*BLQ);

  // Muestra informacin
  textprintf_ex(bmp, fuentes[F_ARUNI_B12].dat, 8, 7*BLQ,
    makecol16(255, 255, 0), -1, "Movimientos:");
  textprintf_centre_ex(bmp, fuentes[F_ARUNI_B12].dat, 5*BLQ/2, 8*BLQ,
    makecol16(255, 255, 255), -1, "[%6d]", movs);

  textprintf_ex(bmp, fuentes[F_ARUNI_B12].dat, 8, 9*BLQ,
    makecol16(255, 255, 0), -1, "Giro:");
  if (dado->giro) sprintf(cad, "S");
  else sprintf(cad, "No");
  textprintf_centre_ex(bmp, fuentes[F_ARUNI_B12].dat, 5*BLQ/2, 10*BLQ,
    makecol16(255, 255, 255), -1, "[-%s-]", cad);

  textprintf_ex(bmp, fuentes[F_ARUNI_B12].dat, 8, 11*BLQ,
    makecol16(255, 255, 0), -1, "Indicadores:");
  if (indicadores) sprintf(cad, "S");
  else sprintf(cad, "No");
  textprintf_centre_ex(bmp, fuentes[F_ARUNI_B12].dat, 5*BLQ/2, 12*BLQ,
    makecol16(255, 255, 255), -1, "[-%s-]", cad);

  switch (dado->accn) {
  // Dado 'feliz' listo para recibir mandatos
  case DA_FLZ:
    // Calcula inclinacin
    if (dado->giro) {
      if (dado->anim >= 0 && dado->anim < 12) x = itofix(dado->anim);
      else if (dado->anim >= 12 && dado->anim < 24) x = itofix(24-dado->anim);
      else if (dado->anim >= 24 && dado->anim < 36) x = itofix(280-dado->anim);
      else x = itofix(dado->anim+208);
    }

    // Dibuja los dados
    /*
    rotate_sprite(bmp, img_cara[dado->caras[C_IZQ]].dat, BLQ, 3*BLQ, x);
    rotate_sprite(bmp, img_cara[dado->caras[C_DER]].dat, 3*BLQ, 3*BLQ, x);
    rotate_sprite(bmp, img_cara[dado->caras[C_ARR]].dat, 2*BLQ, 2*BLQ, x);
    rotate_sprite(bmp, img_cara[dado->caras[C_ABJ]].dat, 2*BLQ, 4*BLQ, x); */

    draw_sprite(bmp, img_cara[dado->caras[C_IZQ]].dat, BLQ, 3*BLQ);
    draw_sprite(bmp, img_cara[dado->caras[C_DER]].dat, 3*BLQ, 3*BLQ);
    draw_sprite(bmp, img_cara[dado->caras[C_ARR]].dat, 2*BLQ, 2*BLQ);
    draw_sprite(bmp, img_cara[dado->caras[C_ABJ]].dat, 2*BLQ, 4*BLQ);
    if (dado->giro)
      rotate_sprite(bmp, img_cara[dado->caras[C_SUP]].dat, 2*BLQ, 3*BLQ, x);
    else
      draw_sprite(bmp, img_cara[dado->caras[C_SUP]].dat, 2*BLQ, 3*BLQ);
    break;

  // Dado haciendo aparicin inicial
  case DA_INI:
    if (dado->anim) {
      x = 2*BLQ + (BLQ - dado->anim)/2;
      y = 3*BLQ + (BLQ - dado->anim)/2;

      draw_sprite(bmp, img_cara[dado->caras[C_IZQ]].dat,
        2*BLQ-dado->anim, 3*BLQ);
      draw_sprite(bmp, img_cara[dado->caras[C_DER]].dat,
        2*BLQ+dado->anim, 3*BLQ);
      draw_sprite(bmp, img_cara[dado->caras[C_ARR]].dat,
        2*BLQ, 3*BLQ-dado->anim);
      draw_sprite(bmp, img_cara[dado->caras[C_IZQ]].dat,
        2*BLQ, 3*BLQ+dado->anim);
      stretch_sprite(bmp, img_cara[dado->caras[C_SUP]].dat,
        x, y, dado->anim, dado->anim);
    }
    else draw_sprite(bmp, img_cara[dado->caras[C_SUP]].dat, 2*BLQ, 3*BLQ);
    break;

  // Dado terminando el mapa
  case DA_FIN:
    // Calcula proporciones
    x = dado->anim < 16 ? BLQ + dado->anim : 2*BLQ - dado->anim;
    y = dado->anim < 16 ? (-dado->anim)/2 : (dado->anim - BLQ)/2;

    draw_sprite(bmp, img_cara[dado->caras[C_IZQ]].dat,
      BLQ+dado->anim, 3*BLQ);
    draw_sprite(bmp, img_cara[dado->caras[C_DER]].dat,
      3*BLQ-dado->anim, 3*BLQ);
    draw_sprite(bmp, img_cara[dado->caras[C_ARR]].dat,
      2*BLQ, 2*BLQ+dado->anim);
    draw_sprite(bmp, img_cara[dado->caras[C_IZQ]].dat,
      2*BLQ, 4*BLQ-dado->anim);
    stretch_sprite(bmp, img_cara[dado->caras[C_SUP]].dat,
      2*BLQ+y, 3*BLQ+y, x, x);
    break;

  // Dado movindose a la izquierda
  case DA_IZQ:
    x = 2 *dado->anim;                // Tamao
    if (dado->anim) {
      y = 12 * dado->anim;            // Cantidad de color
      set_trans_blender(0, 0, 0, 0);  // Sombra

      clear_to_color(auxbmp, makecol16(255, 0, 255));
      stretch_sprite(auxbmp, img_cara[dado->caras[C_IZQ]].dat,
        0, 0, BLQ-x, BLQ);
      draw_lit_sprite(bmp, auxbmp, BLQ, 3*BLQ, y);

      clear_to_color(auxbmp, makecol16(255, 0, 255));
      stretch_sprite(auxbmp, img_cara[dado->caras[C_POS]].dat,
        BLQ-x, 0, x, BLQ);
      draw_lit_sprite(bmp, auxbmp, 3*BLQ, 3*BLQ, 192-y);
    }
    else
      draw_sprite(bmp, img_cara[dado->caras[C_IZQ]].dat, BLQ, 3*BLQ);

    draw_sprite(bmp, img_cara[dado->caras[C_SUP]].dat, 2*BLQ-x, 3*BLQ);
    draw_sprite(bmp, img_cara[dado->caras[C_DER]].dat, 3*BLQ-x, 3*BLQ);
    draw_sprite(bmp, img_cara[dado->caras[C_ARR]].dat, 2*BLQ, 2*BLQ);
    draw_sprite(bmp, img_cara[dado->caras[C_ABJ]].dat, 2*BLQ, 4*BLQ);
    break;

  // Dado movindose a la derecha
  case DA_DER:
    x = 2 *dado->anim;                // Tamao
    if (dado->anim) {
      y = 12 * dado->anim;            // Cantidad de color
      set_trans_blender(0, 0, 0, 0);  // Sombra

      clear_to_color(auxbmp, makecol16(255, 0, 255));
      stretch_sprite(auxbmp, img_cara[dado->caras[C_POS]].dat,
        0, 0, x, BLQ);
      draw_lit_sprite(bmp, auxbmp, BLQ, 3*BLQ, 192-y);

      clear_to_color(auxbmp, makecol16(255, 0, 255));
      stretch_sprite(auxbmp, img_cara[dado->caras[C_DER]].dat,
        x, 0, BLQ-x, BLQ);
      draw_lit_sprite(bmp, auxbmp, 3*BLQ, 3*BLQ, y);
    }
    else
      draw_sprite(bmp, img_cara[dado->caras[C_DER]].dat, 3*BLQ, 3*BLQ);

    draw_sprite(bmp, img_cara[dado->caras[C_SUP]].dat, 2*BLQ+x, 3*BLQ);
    draw_sprite(bmp, img_cara[dado->caras[C_IZQ]].dat, BLQ+x, 3*BLQ);
    draw_sprite(bmp, img_cara[dado->caras[C_ARR]].dat, 2*BLQ, 2*BLQ);
    draw_sprite(bmp, img_cara[dado->caras[C_ABJ]].dat, 2*BLQ, 4*BLQ);
    break;

  // Dado movindose hacia arriba
  case DA_ARR:
    x = 2 *dado->anim;                // Tamao
    if (dado->anim) {
      y = 12 * dado->anim;            // Cantidad de color
      set_trans_blender(0, 0, 0, 0);  // Sombra

      clear_to_color(auxbmp, makecol16(255, 0, 255));
      stretch_sprite(auxbmp, img_cara[dado->caras[C_ARR]].dat,
        0, 0, BLQ, BLQ-x);
      draw_lit_sprite(bmp, auxbmp, 2*BLQ, 2*BLQ, y);

      clear_to_color(auxbmp, makecol16(255, 0, 255));
      stretch_sprite(auxbmp, img_cara[dado->caras[C_POS]].dat,
        0, BLQ-x, BLQ, x);
      draw_lit_sprite(bmp, auxbmp, 2*BLQ, 4*BLQ, 192-y);
    }
    else draw_sprite(bmp, img_cara[dado->caras[C_ARR]].dat, 2*BLQ, 2*BLQ);

    draw_sprite(bmp, img_cara[dado->caras[C_SUP]].dat, 2*BLQ, 3*BLQ-x);
    draw_sprite(bmp, img_cara[dado->caras[C_ABJ]].dat, 2*BLQ, 4*BLQ-x);
    draw_sprite(bmp, img_cara[dado->caras[C_IZQ]].dat, BLQ, 3*BLQ);
    draw_sprite(bmp, img_cara[dado->caras[C_DER]].dat, 3*BLQ, 3*BLQ);
    break;

  // Dado movindose hacia abajo
  case DA_ABJ:
    x = 2 *dado->anim;                // Tamao
    if (dado->anim) {
      y = 12 * dado->anim;            // Cantidad de color
      set_trans_blender(0, 0, 0, 0);  // Sombra

      clear_to_color(auxbmp, makecol16(255, 0, 255));
      stretch_sprite(auxbmp, img_cara[dado->caras[C_POS]].dat,
        0, 0, BLQ, x);
      draw_lit_sprite(bmp, auxbmp, 2*BLQ, 2*BLQ, 192-y);

      clear_to_color(auxbmp, makecol16(255, 0, 255));
      stretch_sprite(auxbmp, img_cara[dado->caras[C_ABJ]].dat,
        0, x, BLQ, BLQ-x);
      draw_lit_sprite(bmp, auxbmp, 2*BLQ, 4*BLQ, y);
    }
    else draw_sprite(bmp, img_cara[dado->caras[C_POS]].dat, 2*BLQ, 4*BLQ);

    draw_sprite(bmp, img_cara[dado->caras[C_SUP]].dat, 2*BLQ, 3*BLQ+x);
    draw_sprite(bmp, img_cara[dado->caras[C_ARR]].dat, 2*BLQ, 2*BLQ+x);
    draw_sprite(bmp, img_cara[dado->caras[C_IZQ]].dat, 1*BLQ, 3*BLQ);
    draw_sprite(bmp, img_cara[dado->caras[C_DER]].dat, 3*BLQ, 3*BLQ);
    break;

  // Dado girando hacia la izquierda
  case DA_GIZ:
    x = dado->anim;               // Distancia
    y = itofix(8 * dado->anim);   // ngulo
    rotate_sprite(bmp, img_cara[dado->caras[C_IZQ]].dat, BLQ+x, 3*BLQ+x, y);
    rotate_sprite(bmp, img_cara[dado->caras[C_DER]].dat, 3*BLQ-x, 3*BLQ-x, y);
    rotate_sprite(bmp, img_cara[dado->caras[C_ARR]].dat, 2*BLQ-x, 2*BLQ+x, y);
    rotate_sprite(bmp, img_cara[dado->caras[C_ABJ]].dat, 2*BLQ+x, 4*BLQ-x, y);
    draw_sprite(bmp, img_cara[dado->caras[C_SUP]].dat, 2*BLQ, 3*BLQ);
    break;

  // Dado girando hacia la derecha
  case DA_GDE:
    x = dado->anim;               // Distancia
    y = itofix(8 * dado->anim);   // ngulo
    rotate_sprite(bmp, img_cara[dado->caras[C_IZQ]].dat, BLQ+x, 3*BLQ-x, 256-y);
    rotate_sprite(bmp, img_cara[dado->caras[C_DER]].dat, 3*BLQ-x, 3*BLQ+x, 256-y);
    rotate_sprite(bmp, img_cara[dado->caras[C_ARR]].dat, 2*BLQ+x, 2*BLQ+x, 256-y);
    rotate_sprite(bmp, img_cara[dado->caras[C_ABJ]].dat, 2*BLQ-x, 4*BLQ-x, 256-y);
    draw_sprite(bmp, img_cara[dado->caras[C_SUP]].dat, 2*BLQ, 3*BLQ);
    break;

  } // ('switch' dado->accn)

  return;
}

/*----- mostrar_ayuda -----*/
void mostrar_ayuda(void) {
  BITMAP *bmp, *fondo;
  int i, j;

  // Prepara bitmap y fondo
  bmp = create_bitmap(400, 400);
  fondo = create_bitmap(400, 400);
  blit(screen, bmp, 40, 40, 0, 0, 400, 400);
  blit(screen, fondo, 40, 40, 0, 0, 400, 400);
  i = text_height(fuentes[F_ARUNI_B12].dat);

  // Prepara el marco
  set_trans_blender(0, 0, 0, 224);
  drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
  rectfill(bmp, 0, 0, 399, 399, makecol16(200, 100, 200));
  rectfill(bmp, 4, 4, 395, i+8, makecol16(200, 100, 200));
  solid_mode();
  rect(bmp, 0, 0, 399, 399, makecol16(255, 255, 255));
  rect(bmp, 4, 4, 395, i+8, makecol16(255, 255, 255));

  // Escribe la ayuda
  textout_centre_ex(bmp, fuentes[F_ARUNI_B12].dat,
    "DADOO, versin 0.41 << 27/SEP/2002 >>", 200, 8,
    makecol16(255, 200, 255), -1);

  // Teclas...
  j = 2;
  textout_ex(bmp, fuentes[F_ARUNI_B12].dat,
    "Flechas:", 8, i*(j++)+8, makecol16(255, 255, 0), -1);
  textout_ex(bmp, fuentes[F_ARUNI_B12].dat,
    "Re.Pg. [PGUP]:", 8, i*(j++)+8, makecol16(255, 255, 0), -1);
  textout_ex(bmp, fuentes[F_ARUNI_B12].dat,
    "Av.Pg. [PGDN]:", 8, i*(j++)+8, makecol16(255, 255, 0), -1);
  textout_ex(bmp, fuentes[F_ARUNI_B12].dat,
    "F6:", 8, i*(j++)+8, makecol16(255, 255, 0), -1);
  textout_ex(bmp, fuentes[F_ARUNI_B12].dat,
    "F7:", 8, i*(j++)+8, makecol16(255, 255, 0), -1);
  textout_ex(bmp, fuentes[F_ARUNI_B12].dat,
    "Escape [ESC]:", 8, i*(j++)+8, makecol16(255, 255, 0), -1);

  // Comandos...
  j = 2;
  textout_ex(bmp, fuentes[F_ARUNI_B12].dat,
    "Movimiento del dado", 200, i*(j++)+8, makecol16(255, 255, 255), -1);
  textout_ex(bmp, fuentes[F_ARUNI_B12].dat,
    "Girar a la izquierda", 200, i*(j++)+8, makecol16(255, 255, 255), -1);
  textout_ex(bmp, fuentes[F_ARUNI_B12].dat,
    "Girar a la derecha", 200, i*(j++)+8, makecol16(255, 255, 255), -1);
  textout_ex(bmp, fuentes[F_ARUNI_B12].dat,
    "Hacer trampa...", 200, i*(j++)+8, makecol16(255, 255, 255), -1);
  textout_ex(bmp, fuentes[F_ARUNI_B12].dat,
    "Indicadores", 200, i*(j++)+8, makecol16(255, 255, 255), -1);
  textout_ex(bmp, fuentes[F_ARUNI_B12].dat,
    "Salir", 200, i*(j++)+8, makecol16(255, 255, 255), -1);

  // Una nota...
  j++;
  textout_ex(bmp, fuentes[F_ARUNI_B12].dat,
    "Nota: El dado slo puede girar una vez por",
    8, i*(j++)+8, makecol16(255, 255, 255), -1);
  textout_ex(bmp, fuentes[F_ARUNI_B12].dat,
    " cada nueva posicin en que es colocado.",
    8, i*(j++)+8, makecol16(255, 255, 255), -1);

  textout_ex(bmp, fuentes[F_ARUNI_B12].dat,
    "Presione [ENTER] para continuar...", 8, 390-i,
    makecol16(245, 225, 180), -1);
  blit(bmp, screen, 0, 0, 40, 40, 400, 400);
  clear_keybuf();
  while (readkey() >> 8 != KEY_ENTER);

  // Restablece pantalla
  blit(fondo, screen, 0, 0, 40, 40, 400, 400);
  destroy_bitmap(bmp);
  destroy_bitmap(fondo);

  return;
}
