/*=============================================================================
Proyecto: DADOO
< editor.c >
25/Marzo/2002
=============================================================================*/

//===== Directivas
#include <allegro.h>
#include <stdio.h>
#include <conio.h>
#include "const.h"
#include "dado.h"
#include "mapa.h"
#include "archivos.h"
#include "editor.h"
#include "imagen.h"

//===== Variables
extern DATAFILE *img_cara;
DATAFILE *imagen;

/*----- editar_mapa -----*/
void editar_mapa(void) {
  BITMAP *panA, *panB;
  MAPA mapa;
  DADO dado;
  int i, j, ai = 0, aj = 0;
  int tecla = KEY_ENTER, resp;
  char nombre[256] = "Mapa0000";

  // Creacin de los paneles o pantallas
  panA = create_bitmap(MAX_X * BLQ, MAX_Y * BLQ);
  clear_bitmap(panA);
  panB = create_bitmap(5 * BLQ, MAX_Y * BLQ);
  clear_bitmap(panB);

  // Carga las imgenes
  imagen = load_datafile(A_IMAGEN);
  if (!imagen) {
    alert("No se pudo abrir el archivo", A_IMAGEN, NULL,
      "Ni modo", NULL, 'n', 0);
    return;
  }

  // Inicializacin del mapa y dado
  dado.posX = dado.posY = 0;
  preparar_dado(&dado);
  if (abrir_mapa(&mapa, nombre, 0)) vaciar_mapa(&mapa);

  // Actualizacin de la pantalla
  clear_bitmap(screen);
  dibujar_mapa(panA, &mapa);
  resaltar_inifin(panA, &mapa, 0);
  blit(panA, screen, 0, 0, 0, 0, MAX_X*BLQ, MAX_Y*BLQ);

  // Permite edicin del mapa
  clear_keybuf();
  i = j = 0;

  while (tecla != KEY_ESC) {
    // Actualiza cursor
    dibujar_espacio(panA, i*BLQ, j*BLQ, &mapa, i, j);
    dibujar_cursor(panA, i*BLQ, j*BLQ);
    dibujar_panel_edicion(panB, &dado, &mapa, nombre);

    // Determina si se requiere actualizar inifin
    if ((i == mapa.iniX && j == mapa.iniY) ||
      (ai == mapa.iniX && aj == mapa.iniY))
      resaltar_inifin(panA, &mapa, 1);
    if ((i == mapa.finX && j == mapa.finY) ||
      (ai == mapa.finX && aj == mapa.finY))
      resaltar_inifin(panA, &mapa, 2);

    blit(panA, screen, 0, 0, 0, 0, MAX_X*BLQ, MAX_Y*BLQ);
    blit(panB, screen, 0, 0, MAX_X*BLQ, 0, 5*BLQ, MAX_Y*BLQ);

    // Nueva entrada
    ai = i; aj = j;
    tecla = readkey() >> 8;

    switch (tecla) {
    case KEY_LEFT:
      if (i > 0) i--; else i = mapa.dimX - 1;
      break;
    case KEY_RIGHT:
      if (i < mapa.dimX - 1) i++; else i = 0;
      break;
    case KEY_UP:
      if (j > 0) j--; else j = mapa.dimY - 1;
      break;
    case KEY_DOWN:
      if (j < mapa.dimY - 1) j++; else j = 0;
      break;
    case KEY_PGUP:
      mover_dado(&dado, GIR_IZQ, 1);
      break;
    case KEY_PGDN:
      mover_dado(&dado, GIR_DER, 1);
      break;
    case KEY_DEL:
      mapa.esp[j][i] = 0;
      break;
    case KEY_HOME:
      dibujar_espacio(panA, mapa.iniX*BLQ, mapa.iniY*BLQ,
        &mapa, mapa.iniX, mapa.iniY);
      mapa.iniX = i;
      mapa.iniY = j;
      break;
    case KEY_END:
      dibujar_espacio(panA, mapa.finX*BLQ, mapa.finY*BLQ,
        &mapa, mapa.finX, mapa.finY);
      mapa.finX = i;
      mapa.finY = j;
      break;
    case KEY_F2:               // Guardar archivo
      resp = guardar_mapa(&mapa, nombre, 1);
      if (resp == 1) alert("No se pudo guardar el archivo.", NULL, NULL,
        "Ni modo", NULL, 'n', 0);
      break;
    case KEY_F3:               // Abrir archivo
      resp = abrir_mapa(&mapa, nombre, 1);
      if (resp == 1) alert("No se pudo abrir el archivo.", NULL, NULL,
        "Ni modo", NULL, 'n', 0);
      // Actualiza el panel A
      dibujar_mapa(panA, &mapa);
      break;
    case KEY_F4:               // Nuevo mapa
      vaciar_mapa(&mapa);
      dibujar_mapa(panA, &mapa);
      resaltar_inifin(panA, &mapa, 0);
      break;
    default:
      if (tecla >= KEY_1 && tecla <= KEY_6)
        mapa.esp[j][i] = tecla - KEY_1 + 1;
      else if (tecla >= KEY_1_PAD && tecla <= KEY_6_PAD)
        mapa.esp[j][i] = tecla - KEY_1_PAD + 1;
    }

    // Redibuja bloque anterior
    dibujar_espacio(panA, ai*BLQ, aj*BLQ, &mapa, ai, aj);
    // Actualiza el dado
    dado.posX = i; dado.posY = j;
    if (mapa.esp[j][i] >= 1 && mapa.esp[j][i] <= 6)
      ajustar_dado(&dado, mapa.esp[j][i]);
  }

  unload_datafile(imagen);
  destroy_bitmap(panA);
  destroy_bitmap(panB);

  return;
}

/*----- resaltar_inifin -----*/
void resaltar_inifin(BITMAP *bmp, MAPA *mapa, int marca) {
  // Configura transparencia
  set_trans_blender(0, 0, 0, 127);

  // Coloca indicadores
  if (marca != 2) {
    draw_trans_sprite(bmp, imagen[IMG_POS_INI].dat,
      mapa->iniX*BLQ, mapa->iniY*BLQ);
  }
  if (marca != 1) {
    draw_trans_sprite(bmp, imagen[IMG_POS_FIN].dat,
      mapa->finX*BLQ, mapa->finY*BLQ);
  }

  return;
}
