/*=============================================================================
Proyecto: DADOO
< archivos.c >
25/Marzo/2002
=============================================================================*/

//===== Directivas
#include <allegro.h>
#include <stdio.h>
#include <conio.h>
#include "const.h"
#include "dado.h"
#include "mapa.h"
#include "archivos.h"
#include "fuentes.h"

//===== Variables
extern DATAFILE *fuentes;

/*----- dialogo_archivo -----*/
int dialogo_archivo(int cx, int cy, char *cadena, char *titulo) {
  BITMAP *fondo, *bmp;
  FONT *fuente = font;
  int dlg;
  // Cuadro de dilogo para guardar mapas
  DIALOG dialogo[] = {
    /*(dlg proc)     (x)  (y)    (w)  (h)  (fg)      (bg)      (key) (flags)
      (d1) (d2) (dp)  (dp2) (dp3) */
    {d_edit_proc,    cx+5,   cy+45, 250, 32,  0xFFFFFF, 0x000000, 0,    0,
      255, 0,   cadena,      NULL, NULL},
    {d_button_proc,  cx+5,   cy+80, 120, 36,  0xFFFFFF, 0x000000, 'a',  D_EXIT,
      0,   0,   "&Aceptar",  NULL, NULL},
    {d_button_proc,  cx+130, cy+80, 120, 36,  0xFFFFFF, 0x000000, 'c',  D_EXIT,
      0,   0,   "&Cancelar", NULL, NULL},
    {NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL}
  };

  // Configura colores del dilogo
  for (dlg = 0; dlg < 3; dlg++) {
    dialogo[dlg].bg = makecol16(46, 152, 152);
  }

  // Configura la fuente y los bitmap
  font = fuentes[F_ARUNI_B12].dat;
  fondo = create_bitmap(260, 150);
  bmp = create_bitmap(260, 150);
  blit(screen, bmp, cx, cy, 0, 0, 260, 150);
  blit(screen, fondo, cx, cy, 0, 0, 260, 150);

  // Dibuja el marco
  set_trans_blender(0, 0, 0, 127);
  drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
  rectfill(bmp, 0, 0, 259, 149, makecol16(54, 160, 160));
  solid_mode();
  rect(bmp, 0, 0, 259, 149, makecol16(255, 255, 255));
  textout_ex(bmp, fuentes[F_MICRO_18].dat, titulo,
    5, 5, makecol16(255, 255, 255), -1);
  blit(bmp, screen, 0, 0, cx, cy, 260, 150);

  do {
    // Ejecuta el dilogo
    dlg = do_dialog(dialogo, 0);
    // Corrige el nombre
    if (dlg != 2 && dlg != -1) {
      if (corregir_nombre(cadena)) continue;
      else break;
    }
  } while (dlg != 2 && dlg != -1);

  // Restablece fuente y fondo
  font = fuente;
  blit(fondo, screen, 0, 0, cx, cy, 260, 150);

  destroy_bitmap(fondo);
  destroy_bitmap(bmp);

  return dlg;
}

/*----- guardar_mapa -----*/
int guardar_mapa(MAPA *mapa, char *nombre, int preg) {
  FILE *arch;
  char nomant[512];
  int resp = 0;

  // Prepara el dilogo
  sprintf(nomant, "%s", nombre);
  if (preg) {
    //resp = dialogo_archivo(100, 100, nombre, "Guardar como...");
    resp = file_select_ex("Guardar como...", nombre, "doo", 512, 400, 300);
    if (resp == 0) {
      sprintf(nombre, "%s", nomant);
      return 1;
    }

    // El archivo ya existe
    if (exists(nombre)) {
      resp = alert("Desea sobreescribir", "el siguiente archivo?:", nombre,
        "Aceptar", "Cancelar", 's', 'c');
    }
  }

  // Guarda el archivo
  if (resp == 2) {
    sprintf(nombre, "%s", nomant);
    return 2;
  }
  arch = fopen(nombre, "wb");
  if (!arch) {
    sprintf(nombre, "%s", nomant);
    return 1;
  }
  fwrite(mapa, sizeof(MAPA), 1, arch);
  fclose(arch);

  return 0;
}

/*----- abrir_mapa -----*/
int abrir_mapa(MAPA *mapa, char *nombre, int preg) {
  FILE *arch;
  char nomant[512];
  int resp;

  // Prepara el dilogo
  sprintf(nomant, "%s", nombre);
  if (preg) {
    //resp = dialogo_archivo(100, 100, nombre, "Abrir mapa...");
    resp = file_select_ex("Abrir mapa...", nombre, "doo", 512, 400, 300);
    if (resp == 0) {
      sprintf(nombre, "%s", nomant);
      return 1;
    }
  }

  // Abre el archivo
  arch = fopen(nombre, "rb");
  if (!arch) {
    sprintf(nombre, "%s", nomant);
    return 1;
  }
  fread(mapa, sizeof(MAPA), 1, arch);
  fclose(arch);

  return 0;
}

/*----- corregir_nombre -----*/
int corregir_nombre(char *nombre) {
  char proh[] = "\\/:*?\"<>|";
  char c, d, *ext;
  int i = 0, j = 0;

  // Busca carcteres no-vlidos
  while ((c = *(nombre + i))) {
    j = 0;
    while ((d = *(proh + j))) {
      if (c == d) {
        alert("El nombre del archivo no debe contener",
          "ninguno de los siguientes carcteres:", proh, "Ni modo", NULL, 0, 0);
        return 1;
      }
      j++;
    }
    i++;
  }

  // Busca la extensin
  ext = get_extension(nombre);
  if (!*ext) replace_extension(nombre, nombre, "doo", 255);

  return 0;
}
