/* minigamemanager.cpp
 *
 * Game Management
 *
 * by BAF (c) 2006 Robert A. Ferris III
 *  made for TINS 2006
 */

/*
  Train Stopper, version 1.0, March 05, 2006

  Copyright (C) 2006 Robert Ferris

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Robert Ferris baf@bafsoft.com
	*/

#include <allegro.h>
#include <string>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "misc.h"
#include "minigamemanager.h"

using MiniGameManagement::MiniGameManager;
using namespace std;

MiniGameManager::MiniGameManager() : CurGame(NULL), CurInf(NULL), WonLastGame(false), ActivePlay(false), HelpShow(false), LastWonPoints(0)
{
	srand(time(NULL));
}

MiniGameManager::~MiniGameManager()
{
}


void MiniGameManager::RegisterMiniGame(MiniGameManagement::MGFactory Factory)
{
	MiniGames.push_back(Factory);
}


void MiniGameManager::NewMiniGame()
{
	int NewIdx = rand() % MiniGames.size();
	
	if(CurGame)
	{
		EndMiniGame();
	}
	
	ActivePlay = true;
	CurGame = (*MiniGames[NewIdx])();
	CurInf = CurGame->GetInfo();
}

void MiniGameManager::NewMiniGame(int NewIdx)
{
	if(CurGame)
	{
		EndMiniGame();
	}
	
	ActivePlay = true;
	CurGame = (*MiniGames[NewIdx])();
	CurInf = CurGame->GetInfo();
}

void MiniGameManager::EndMiniGame()
{
	if(CurGame)
	{
		WonLastGame = CurGame->WonGame;
		if(WonLastGame)
			LastWonPoints = CurInf->Points;
		else
			LastWonPoints = 0;
		ActivePlay = CurGame->Playing = false;
		delete CurGame;
		CurGame = NULL;
		delete CurInf;
		CurInf = NULL;
	}
}


void MiniGameManager::Tick(int TimeLeft)
{
	if(!CurGame)
		return;
	
	if(!HelpShow)
	{
		CurGame->Tick(TimeLeft);
		if(!CurGame->Playing)
			EndMiniGame();
	}
	
	if(key[KEY_F1] && !HelpShow)
		HelpShow = true;
	if(keypressed() && HelpShow)
	{
		readkey(); // remove key from buffer
		HelpShow = false;
	}
}

void MiniGameManager::Draw(BITMAP *Buffer)
{
	if(!CurGame)
		return;
	
	CurGame->Draw(Buffer);
	textprintf_ex(Buffer, font, 0, 0, makecol(255, 255, 255), makecol(0, 0, 0), "Mini Game: %s", CurInf->GameName.c_str());
	
	if(HelpShow)
	{
		// Show Help
		Misc::Obscure(Buffer);
		
		char *HelpText = new char[1024];
		snprintf(HelpText, 1024, "Help for %s\n\n%s\n\nPress any key (except F1 or Escape) to continue...\n", CurInf->GameName.c_str(), CurInf->Directions.c_str());
		int h = Misc::MGMtextoutWordWrap(Buffer, font, 100, 100, SCREEN_W - 200, SCREEN_H - 200, makecol(255, 255, 255), makecol(0, 0, 0), HelpText);
		rect(Buffer, 90, 90, SCREEN_W - 90, 10 + h, makecol(128, 64, 128));
		delete[] HelpText;
	}
}
