/* mgmenu.cpp
 *
 * Mini-game menu
 *
 * by BAF (c) 2006 Robert A. Ferris III
 *  made for TINS 2006
 */

/*
  Train Stopper, version 1.0, March 05, 2006

  Copyright (C) 2006 Robert Ferris

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Robert Ferris baf@bafsoft.com
	*/

#include <allegro.h>
#include <string>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "misc.h"
#include "mgmenu.h"

using MiniGameManagement::MGMenu;
using namespace std;

MGMenu::MGMenu(vector<MGFactory> MiniGames) : MiniGames(MiniGames)
{
}

MGMenu::~MGMenu()
{
}


int MGMenu::GetChoice(int *GameTime)
{
	// Do up a menu and get the choice.
	int Selection = 0;
	int NumGames = MiniGames.size();
	
	// Get game info
	MiniGames::MiniGame **Games;
	Games = new MiniGames::MiniGame*[NumGames];
	MiniGames::MiniGameInfo **GamesI;
	GamesI = new MiniGames::MiniGameInfo*[NumGames];
	for(int i = 0; i < NumGames; ++i)
	{
		Games[i] = (*MiniGames[i])();
		GamesI[i] = Games[i]->GetInfo();
	}
	
	BITMAP *buffer = create_bitmap(SCREEN_W, SCREEN_H);
	
	// Do Menu!
	clear_keybuf();
	bool done = false;
	while(!done)
	{
		// We hijack the main timer.
		while((*GameTime) > 0)
		{
			poll_keyboard();
			
			if(keypressed())
			{
				int key = readkey() >> 8;
				
				if(key == KEY_UP && Selection > 0)
					--Selection;
				if(key == KEY_DOWN && Selection < NumGames - 1)
					++Selection;
				
				if(key == KEY_ENTER)
					done = true;
			}
			
			--(*GameTime);
		}
		
		// Draw
		clear_bitmap(buffer);
		for(int i = 0; i < NumGames; ++i)
		{
			textprintf_ex(buffer, font, 15, 15 + (i * text_height(font)), makecol(255, 255, 255), makecol(0, 0, 0), "%s %s", ((Selection == i) ? "-->" : "  "), GamesI[i]->GameName.c_str());
		}
		blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	}
	
	// clean up
	for(int i = 0; i < NumGames; ++i)
	{
		delete GamesI[i];
		delete Games[i];
	}
	delete[] Games;
	delete[] GamesI;
	destroy_bitmap(buffer);
	
	return Selection;
}
